/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import jm.music.data.Phrase;
import jm.music.tools.ga.FitnessEvaluater;
import jm.music.tools.ga.Mutater;
import jm.music.tools.ga.ParentSelector;
import jm.music.tools.ga.PopulationInitialiser;
import jm.music.tools.ga.Recombiner;
import jm.music.tools.ga.SurvivorSelector;
import jm.music.tools.ga.TerminationCriteria;

public class PhrGeneticAlgorithm {
    protected Phrase[] population;
    protected double[] fitness;
    protected PopulationInitialiser populationInitialiser;
    protected FitnessEvaluater fitnessEvaluater;
    protected TerminationCriteria terminationCriteria;
    protected ParentSelector parentSelector;
    protected Recombiner recombiner;
    protected Mutater mutater;
    protected SurvivorSelector survivorSelector;
    protected int beatsPerBar;
    protected long iteration;
    protected double initialLength;
    protected int initialSize;
    protected int originalSize;
    protected boolean finished;

    public PhrGeneticAlgorithm(Phrase phrase, int beatsPerBar, PopulationInitialiser populationInitialiser, FitnessEvaluater fitnessEvaluater, TerminationCriteria terminationCriteria, ParentSelector parentSelector, Recombiner recombiner, Mutater mutater, SurvivorSelector survivorSelector) {
        this.beatsPerBar = beatsPerBar;
        this.initialLength = phrase.getEndTime();
        this.originalSize = this.initialSize = phrase.size();
        this.populationInitialiser = populationInitialiser;
        this.fitnessEvaluater = fitnessEvaluater;
        this.terminationCriteria = terminationCriteria;
        this.parentSelector = parentSelector;
        this.recombiner = recombiner;
        this.mutater = mutater;
        this.survivorSelector = survivorSelector;
        this.setUpNewPopulation(phrase);
    }

    private static int rand(int left, int right) {
        return left + (int)(Math.random() * (double)(right - left)) + 1;
    }

    public void setUpNewPopulation(Phrase phrase) {
        this.iteration = 0L;
        this.population = this.populationInitialiser.initPopulation(phrase, this.beatsPerBar);
        this.fitness = this.fitnessEvaluater.evaluate(this.population);
    }

    public void setBeatsPerBar(int beats) {
        this.beatsPerBar = beats;
    }

    public void zeroInitialSize() {
        this.originalSize = this.initialSize;
        this.initialSize = 0;
    }

    public void restoreInitialSize() {
        this.initialSize = this.originalSize;
    }

    public long getIteration() {
        return this.iteration;
    }

    public boolean iterate() {
        this.finished = this.terminationCriteria.isFinished(this.population);
        if (!this.finished) {
            ++this.iteration;
            Phrase[] parents = this.parentSelector.selectParents(this.population, this.fitness);
            Phrase[] recombined = this.recombiner.recombine(parents, this.fitness, this.initialLength, this.initialSize, this.beatsPerBar);
            Phrase[] children = this.mutater.mutate(recombined, this.initialLength, this.initialSize, this.beatsPerBar);
            double[] parentsFitness = this.fitnessEvaluater.evaluate(children);
            this.population = this.survivorSelector.selectSurvivors(this.population, this.fitness, children, parentsFitness);
            this.fitness = this.fitnessEvaluater.evaluate(this.population);
            return true;
        }
        return false;
    }

    public long iterate(long iterations) {
        long iterationsProcessed = iterations;
        int i = 0;
        while ((long)i < iterations) {
            this.iterate();
            if (this.finished) {
                iterationsProcessed = i;
                break;
            }
            ++i;
        }
        return iterationsProcessed;
    }

    public double[] getFitness() {
        return this.fitness;
    }

    public Phrase[] getPopulation() {
        return this.population;
    }

    public Phrase[] getOrderedPopulation() {
        this.quicksort();
        return this.population;
    }

    private void quicksort() {
        this.quicksort(0, this.population.length - 1);
    }

    private void quicksort(int left, int right) {
        if (left >= right) {
            return;
        }
        this.swap(left, PhrGeneticAlgorithm.rand(left, right));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (!(this.fitness[i] < this.fitness[left])) continue;
            this.swap(++last, i);
        }
        this.swap(left, last);
        this.quicksort(left, last - 1);
        this.quicksort(last + 1, right);
    }

    private void swap(int i, int j) {
        Phrase tempPhrase = this.population[i];
        this.population[i] = this.population[j];
        this.population[j] = tempPhrase;
        double tempDouble = this.fitness[i];
        this.fitness[i] = this.fitness[j];
        this.fitness[j] = tempDouble;
    }

    public double getBestFitness() {
        double bestFitness = 0.0;
        int index = -1;
        for (int i = 0; i < this.fitness.length; ++i) {
            if (!(this.fitness[i] > bestFitness)) continue;
            bestFitness = this.fitness[i];
            index = i;
        }
        return bestFitness;
    }

    public double getAverageFitness() {
        double fitnessCount = 0.0;
        for (int i = 0; i < this.fitness.length; ++i) {
            fitnessCount += this.fitness[i];
        }
        return fitnessCount / (double)this.fitness.length;
    }

    public double getStandardDeviation() {
        double avgFitness = this.getAverageFitness();
        double stDevCount = 0.0;
        for (int i = 0; i < this.fitness.length; ++i) {
            stDevCount += (avgFitness - this.fitness[i]) * (avgFitness - this.fitness[i]);
        }
        return Math.sqrt(stDevCount) / (double)this.fitness.length;
    }

    public Phrase getBestIndividual() {
        double bestFitness = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < this.fitness.length; ++i) {
            if (!(this.fitness[i] < bestFitness)) continue;
            bestFitness = this.fitness[i];
            index = i;
        }
        return this.population[index];
    }

    public Mutater getMutater() {
        return this.mutater;
    }
}

