/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jm.JMC;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.gui.wave.WaveFileReader;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.rt.RTLine;
import jm.music.rt.RTPhrase;
import jm.util.AudioFilePlayThread;
import jm.util.AudioRTLine;
import jm.util.Read;

public class Play
implements JMC {
    private static Vector cyclePlaying = new Vector();
    private static Thread pauseThread;
    private static Vector ms;
    private static AudioInputStream audioInputStream;
    private static Vector mixerList;
    private static boolean audioPlaying;
    private static boolean audioPaused;
    private static RTMixer mixer;
    private static MidiSynth midiSynth1;
    private static MidiSynth midiSynth2;
    private static int msCnt;

    private static void msFill(int numb) {
        if (ms.size() < numb) {
            for (int i = ms.size(); i < numb; ++i) {
                ms.add(new MidiSynth());
            }
        }
    }

    public static boolean cycleIsPlaying() {
        return Play.cycleIsPlaying(0);
    }

    public static boolean cycleIsPlaying(int index) {
        if (cyclePlaying.size() < index + 1) {
            for (int i = cyclePlaying.size(); i < index + 1; ++i) {
                cyclePlaying.addElement(false);
            }
            cyclePlaying.add(index, false);
        }
        return (Boolean)cyclePlaying.elementAt(index);
    }

    public static void waitCycle(Score score, int decayAllowance) {
        try {
            Thread.sleep((int)(60000.0 / score.getTempo() * score.getEndTime()) + decayAllowance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mid(String fileName) {
        Score score = new Score();
        Read.midi(score, fileName);
        Play.midi(score);
    }

    public static void midi(Note n) {
        Play.midi(n, true);
    }

    public static void midi(Phrase phr) {
        Play.midi(phr, true);
    }

    public static void midi(Part part) {
        Play.midi(part, true);
    }

    public static void midi(Score score) {
        Play.midi(score, true);
    }

    public static void midi(Note n, boolean exit) {
        Score s = new Score("One note score", 60.0);
        s.addPart(new Part(new Phrase(n)));
        Play.midi(s, exit);
    }

    public static void midi(Phrase phr, boolean exit) {
        double tempo = 60.0;
        if (phr.getTempo() != -1.0) {
            tempo = phr.getTempo();
        }
        Score s = new Score(phr.getTitle() + " score", tempo);
        if (phr.getTempo() != -1.0) {
            s.setTempo(phr.getTempo());
        }
        s.addPart(new Part(phr));
        Play.midi(s, exit);
    }

    public static void midi(Part p, boolean exit) {
        double tempo = 60.0;
        if (p.getTempo() != -1.0) {
            tempo = p.getTempo();
        }
        Score s = new Score(p.getTitle() + " score", tempo);
        if (p.getTempo() != -1.0) {
            s.setTempo(p.getTempo());
        }
        s.addPart(p);
        Play.midi(s, exit);
    }

    public static void midi(Score score, boolean exit) {
        Play.midi(score, exit, true, 1, 0);
    }

    public static void midi(Score score, boolean exit, boolean wait, int synths, int decayAllowance) {
        System.out.println("jMusic Play: Playing score " + score.getTitle() + " using JavaSound General MIDI soundbank.");
        Play.msFill(synths);
        MidiSynth currentMidiSynth = (MidiSynth)ms.elementAt(msCnt);
        if (currentMidiSynth.isPlaying()) {
            currentMidiSynth.stop();
        }
        try {
            currentMidiSynth.play(score);
            if (wait) {
                System.out.println("jMusic Play: Waiting for the end of " + score.getTitle() + ".");
                if (exit && decayAllowance == 0) {
                    Play.waitCycle(score, 200);
                } else {
                    Play.waitCycle(score, decayAllowance);
                }
            }
        }
        catch (Exception e) {
            System.err.println("jMusic Play: MIDI Playback Error:" + e);
            return;
        }
        if (exit) {
            Play.closeAll();
        }
        msCnt = (msCnt + 1) % synths;
    }

    public static void updateScore(Score s) {
        Play.updateScore(s, 0);
    }

    public static void updateScore(Score s, int index) {
        try {
            ((MidiSynth)ms.elementAt(index)).updateSeq(s);
        }
        catch (Exception e) {
            System.err.println("jMusic Play class can't update MIDI sequence:" + e);
            return;
        }
    }

    public static void pauseAudio() {
        for (int i = 0; i < mixerList.size(); ++i) {
            ((RTMixer)mixerList.elementAt(i)).pause();
        }
        audioPaused = true;
    }

    public static void unPauseAudio() {
        if (audioPaused) {
            for (int i = 0; i < mixerList.size(); ++i) {
                ((RTMixer)mixerList.elementAt(i)).unPause();
            }
            audioPaused = false;
        } else {
            System.err.println("Play.unPauseAudio error: audio playback was not previously paused.");
        }
    }

    public static void stopAudio() {
        for (int i = 0; i < mixerList.size(); ++i) {
            ((RTMixer)mixerList.elementAt(i)).stop();
        }
        audioPaused = false;
        audioPlaying = false;
    }

    public static void stopMidi() {
        for (int i = 0; i < ms.size(); ++i) {
            Play.stopMidi(i);
        }
    }

    public static void stopMidi(int index) {
        System.out.println("jMusic Play: Stopping JavaSound MIDI playback of " + index);
        if (cyclePlaying.size() < index + 1) {
            for (int i = cyclePlaying.size(); i < index + 1; ++i) {
                cyclePlaying.addElement(false);
            }
        }
        cyclePlaying.set(index, false);
        ((MidiSynth)ms.elementAt(index)).stop();
    }

    public static void stopMidiCycle() {
        Play.stopMidiCycle(0);
    }

    public static void stopMidiCycle(int index) {
        System.out.println("jMusic Play: Stopping cycle playback at end of next sequence");
        cyclePlaying.set(index, false);
        ((MidiSynth)ms.elementAt(index)).setCycle(false);
    }

    public static void midiCycle(Note n) {
        Play.midiCycle(n, 0);
    }

    public static void midiCycle(Note n, int index) {
        Score s = new Score("One note score");
        s.addPart(new Part(new Phrase(n)));
        Play.midiCycle(s, index);
    }

    public static void midiCycle(Phrase phr) {
        Play.midiCycle(phr, 0);
    }

    public static void midiCycle(Phrase phr, int index) {
        Score s = new Score(phr.getTitle() + " score");
        s.addPart(new Part(phr));
        Play.midiCycle(s, index);
    }

    public static void midiCycle(Part part) {
        Play.midiCycle(part, 0);
    }

    public static void midiCycle(Part part, int index) {
        Score s = new Score(part.getTitle() + " score");
        s.addPart(part);
        Play.midiCycle(s, index);
    }

    public static void midiCycle(Score score) {
        Play.midiCycle(score, 0);
    }

    public static void midiCycle(Score score, int index) {
        int i;
        if (ms.size() < index + 1) {
            for (i = ms.size(); i < index + 1; ++i) {
                ms.addElement(new MidiSynth());
            }
        }
        if (cyclePlaying.size() < index + 1) {
            for (i = cyclePlaying.size(); i < index + 1; ++i) {
                cyclePlaying.addElement(false);
            }
        }
        if (((Boolean)cyclePlaying.elementAt(index)).booleanValue()) {
            Play.stopMidiCycle(index);
            ((MidiSynth)ms.elementAt(index)).stop();
        }
        cyclePlaying.set(index, true);
        System.out.println("jMusic Play: Starting cycle playback");
        try {
            ((MidiSynth)ms.elementAt(index)).play(score);
            ((MidiSynth)ms.elementAt(index)).setCycle(true);
        }
        catch (Exception e) {
            System.err.println("MIDI Playback Error:" + e);
            return;
        }
    }

    public static void au(String fileName) {
        Play.au(fileName, true);
    }

    public static void au(String fileName, boolean autoClose) {
        WaveFileReader afr = new WaveFileReader(fileName);
        RTLine[] lineArray = new RTLine[]{new AudioRTLine(fileName)};
        RTMixer mixer = new RTMixer(lineArray);
        mixer.begin();
        System.out.println("---------- Playing '" + fileName + "'... Sample rate = " + afr.getSampleRate() + " Channels = " + afr.getChannels() + " ----------");
        if (autoClose) {
            File audioFile = new File(fileName);
            try {
                int byteSize = afr.getBits() - 1;
                Thread.sleep((int)((double)audioFile.length() / (double)byteSize / (double)afr.getSampleRate() / (double)afr.getChannels() * 1000.0));
            }
            catch (InterruptedException e) {
                System.err.println("jMusic play.au error: Thread sleeping interupted");
            }
            System.out.println("-------------------- Completed Audio Playback ----------------------");
            System.exit(0);
        }
    }

    public static void audioFile(String fileName) {
        try {
            audioInputStream = AudioSystem.getAudioInputStream(new File(fileName));
            new AudioFilePlayThread(audioInputStream).start();
            System.out.println("Playing audio file " + fileName);
        }
        catch (IOException ioe) {
            System.err.println("Play audioFile error: in playAudioFile(): " + ioe.getMessage());
        }
        catch (UnsupportedAudioFileException uafe) {
            System.err.println("Unsupported Audio File error: in Play.audioFile():" + uafe.getMessage());
        }
    }

    public static void audio(Note note, Instrument inst) {
        Play.audio(new Phrase(note), inst);
    }

    public static void audio(Phrase phrase, Instrument[] insts) {
        Play.audio(new Score(new Part(phrase)), insts);
    }

    public static void audio(Phrase phrase, Instrument inst) {
        Part part = new Part(phrase);
        if (phrase.getTempo() != -1.0) {
            part.setTempo(phrase.getTempo());
        }
        Play.audio(part, new Instrument[]{inst});
    }

    public static void audio(Part part, Instrument[] insts) {
        Score score = new Score(part);
        if (part.getTempo() != -1.0) {
            score.setTempo(part.getTempo());
        }
        Play.audio(score, insts);
    }

    public static void audio(Score score, Instrument[] insts) {
        audioPlaying = true;
        System.out.print("Playing Score as Audio... ");
        for (int i = 0; i < insts.length; ++i) {
            insts[i].setOutput(1);
        }
        Vector<Phrase> v = new Vector<Phrase>();
        for (int i = 0; i < score.size(); ++i) {
            Part p = score.getPart(i);
            for (int j = 0; j < p.size(); ++j) {
                Phrase phr = p.getPhrase(j);
                if (phr.getInstrument() == -1) {
                    phr.setInstrument(p.getInstrument());
                }
                if (phr.getTempo() == -1.0) {
                    phr.setTempo(p.getTempo());
                }
                v.addElement(phr);
            }
        }
        RTLine[] lines = new RTLine[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Phrase phr = (Phrase)v.elementAt(i);
            lines[i] = new RTPhrase(phr, insts[phr.getInstrument()]);
        }
        if (mixer == null) {
            mixer = new RTMixer(lines);
            mixer.begin();
        } else {
            mixer.addLines(lines);
        }
    }

    private static void audioWait(final Score score, RTMixer mixer) {
        pauseThread = new Thread(new Runnable(){

            public void run() {
                try {
                    pauseThread;
                    Thread.sleep((int)(score.getEndTime() * 60.0 / score.getTempo() * 1000.0));
                }
                catch (Exception e) {
                    System.out.println("jMusic Play.audioWait error in pauseThread");
                }
                System.out.println("Completed audio playback.");
                audioPaused = true;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        pauseThread.start();
    }

    public static void audioClip(String fileName) {
        System.out.println("-------- Playing an audio file ----------");
        System.out.println("Loading sound into memory, please wait...");
        File audioFile = new File(fileName);
        try {
            URI tempURI = audioFile.toURI();
            URL tempURL = tempURI.toURL();
            AudioClip sound = Applet.newAudioClip(tempURL);
            System.out.println("Playing '" + fileName + "' ...");
            sound.play();
        }
        catch (MalformedURLException e) {
            System.err.println("jMusic play.au error: malformed URL or filename");
        }
        try {
            Thread.sleep((int)((double)audioFile.length() / 2.0 / 44100.0 / 2.0 * 1000.0) + 1000);
        }
        catch (InterruptedException e) {
            System.err.println("jMusic play.au error: Thread sleeping interupted");
        }
        System.out.println("-------------------- Completed Playback ----------------------");
        System.exit(0);
    }

    public static void closeAll() {
        audioInputStream = null;
        for (int i = 0; i < ms.size(); ++i) {
            ((MidiSynth)ms.elementAt(i)).finalize();
        }
        ms.clear();
    }

    static {
        ms = new Vector();
        mixerList = new Vector();
        audioPlaying = false;
        audioPaused = false;
        midiSynth1 = new MidiSynth();
        midiSynth2 = new MidiSynth();
        msCnt = 0;
    }
}

