/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFileButton
extends Button {
    private ReadListenerLinkedList readListenerList;

    public ReadFileButton(final Frame owner) {
        super("Read File");
        final FileDialog load = new FileDialog(owner, "Select a Midi or jMusic file to import", 0);
        load.setFilenameFilter(new ReadFilenameFilter());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                load.show();
                Score score = Read.midiOrJmWithAWTMessaging(load.getDirectory(), load.getFile(), owner);
                if (score == null) {
                    return;
                }
                if (ReadFileButton.this.readListenerList != null) {
                    score = ReadFileButton.this.readListenerList.scoreRead(score);
                    ReadFileButton.this.readListenerList.finishedReading();
                }
            }
        });
    }

    public void addReadListener(ReadListener l) {
        if (l == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(l);
        } else {
            this.readListenerList.add(l);
        }
    }

    public void removeReadListener(ReadListener l) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == l) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }
}

