/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFolderButton
extends Button {
    private ReadListenerLinkedList readListenerList;

    public ReadFolderButton(final Frame owner) {
        super("Read Folder");
        final FileDialog load = new FileDialog(owner, "Select a file to read all Midi and JMusic within that file's folder", 0);
        final ReadFilenameFilter filter = new ReadFilenameFilter();
        load.setFilenameFilter(filter);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                load.show();
                String directoryName = load.getDirectory();
                if (directoryName == null) {
                    return;
                }
                String[] filenames = new File(directoryName).list(filter);
                for (int i = 0; i < filenames.length; ++i) {
                    Score score = Read.midiOrJmWithAWTMessaging(directoryName, filenames[i], owner);
                    if (score == null || ReadFolderButton.this.readListenerList == null) continue;
                    ReadFolderButton.this.readListenerList.scoreRead(score);
                }
                if (ReadFolderButton.this.readListenerList != null) {
                    ReadFolderButton.this.readListenerList.finishedReading();
                }
            }
        });
    }

    public void addReadListener(ReadListener l) {
        if (l == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(l);
        } else {
            this.readListenerList.add(l);
        }
    }

    public void removeReadListener(ReadListener l) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == l) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }
}

