/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.core.trans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);
    private static final Map<Class<?>, Field> ID_FIELD_CACHE_MAP = new HashMap();
    public static final Set<Class> ID_ANNO = new HashSet<Class>();

    public static void setValue(Object obj, String fieldName, Object value) {
        Field field = null;
        try {
            if (obj instanceof Map) {
                ((Map)obj).put(fieldName, value);
                return;
            }
            field = ReflectUtils.getDeclaredField(obj.getClass(), fieldName);
            if (field == null) {
                return;
            }
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            log.error("\u7ed9" + obj + "\u7684\u5b57\u6bb5" + fieldName + "\u8bbe\u7f6e\u503c" + value + "\u9519\u8bef", (Throwable)e);
        }
    }

    public static void setValue(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (SecurityException e) {
            log.error("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("", (Throwable)e);
        }
    }

    public static Object newInstance(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }

    public static Map<String, Object> getClassFiledMap(Class<?> clas) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = clas.getDeclaredFields()) {
            map.put(field.getName(), field.getType());
        }
        return map;
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        Field field = null;
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static List<Field> getAllField(Object object) {
        Class<?> clazz = object.getClass();
        return ReflectUtils.getAllField(clazz);
    }

    public static List<Field> getAllField(Class clazz) {
        Field[] fields = null;
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != Object.class) {
            try {
                fields = clazz.getDeclaredFields();
                result.addAll(Arrays.asList(fields));
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Object getValue(Object obj, String fieldName) {
        try {
            if (obj instanceof Map) {
                Object result = ((Map)obj).get(fieldName);
                return result;
            }
            List<Field> declaredfields = ReflectUtils.getAllField(obj.getClass());
            for (int i = 0; i < declaredfields.size(); ++i) {
                if (!declaredfields.get(i).getName().equals(fieldName)) continue;
                Field field = declaredfields.get(i);
                field.setAccessible(true);
                return field.get(obj);
            }
        }
        catch (SecurityException e) {
            log.error("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("", (Throwable)e);
        }
        return "";
    }

    public static Object getValueFromAllFields(Object obj, String fieldName, int fatherIndex) {
        try {
            if (obj instanceof Map) {
                Object result = ((Map)obj).get(fieldName);
                return result;
            }
            Class<?> superClass = obj.getClass();
            for (int i = 0; i < fatherIndex; ++i) {
                superClass = superClass.getSuperclass();
            }
            Field[] superDeclaredfields = superClass.getDeclaredFields();
            for (int i = 0; i < superDeclaredfields.length; ++i) {
                if (!superDeclaredfields[i].getName().equals(fieldName)) continue;
                Field field = superDeclaredfields[i];
                field.setAccessible(true);
                return field.get(obj);
            }
        }
        catch (SecurityException e) {
            log.error("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("", (Throwable)e);
        }
        return "";
    }

    public static boolean checkFiledIsExit(Object obj, String fieldName) {
        if (obj instanceof Map) {
            return ((Map)obj).containsKey(fieldName);
        }
        Field field = ReflectUtils.getDeclaredField(obj.getClass(), fieldName);
        return field != null;
    }

    public static <T extends Annotation> List<Field> getAnnotationField(Class<?> clazz, Class<T> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        List<Field> fields = ReflectUtils.getAllField(clazz);
        for (Field field : fields) {
            if (field.getAnnotation(annotationClass) == null) continue;
            result.add(field);
        }
        return result;
    }

    public static boolean checkFiledIsExit(Class<?> clazz, String fieldName) {
        if (clazz == Map.class) {
            return true;
        }
        Field field = ReflectUtils.getDeclaredField(clazz, fieldName);
        return field != null;
    }

    public static List<Method> getAllMethod(Class<?> clazz) {
        return Arrays.asList(clazz.getMethods());
    }

    public static Method getMethodd(Class<?> clazz, String name) {
        List methods = Arrays.asList(clazz.getMethods()).stream().filter(method -> name.equals(method.getName())).collect(Collectors.toList());
        return methods.isEmpty() ? null : (Method)methods.get(0);
    }

    public static Field getIdField(Class clazz, boolean isThrowError) {
        if (ID_FIELD_CACHE_MAP.containsKey(clazz)) {
            return ID_FIELD_CACHE_MAP.get(clazz);
        }
        Field idField = null;
        List<Field> fieldList = null;
        for (Class anno : ID_ANNO) {
            fieldList = ReflectUtils.getAnnotationField(clazz, anno);
            if (fieldList.isEmpty()) continue;
            idField = fieldList.get(0);
            break;
        }
        if (idField == null && (idField = ReflectUtils.getDeclaredField(clazz, "id")) == null && isThrowError) {
            throw new RuntimeException("\u627e\u4e0d\u5230" + clazz + "\u7684id\u6ce8\u89e3");
        }
        if (idField != null) {
            idField.setAccessible(true);
            ID_FIELD_CACHE_MAP.put(clazz, idField);
            return idField;
        }
        return null;
    }
}

