/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.cache.service.impl;

import com.fhs.cache.service.RedisCacheService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.CollectionUtils;

public class RedisCacheServiceImpl<E>
implements RedisCacheService<E> {
    @Resource(name="redisTemplate")
    private RedisTemplate<String, E> redisTemplate;
    @Autowired
    private RedisTemplate<String, String> strRedisTemplate;
    private Lock lock = new ReentrantLock();

    @Override
    public void put(String key, E obj) {
        ValueOperations valueOper = this.redisTemplate.opsForValue();
        valueOper.set((Object)key, obj);
    }

    @Override
    public E get(String key) {
        ValueOperations valueOper = this.redisTemplate.opsForValue();
        return (E)valueOper.get((Object)key);
    }

    @Override
    public List<E> getList(String key) {
        ListOperations valueOper = this.redisTemplate.opsForList();
        return valueOper.range((Object)key, 0L, -1L);
    }

    @Override
    public Long remove(final String key) {
        if (!this.exists(key)) {
            return 0L;
        }
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                long result = 0L;
                result = connection.del((byte[][])new byte[][]{key.getBytes()});
                return result;
            }
        });
    }

    @Override
    public Long removeStr(final String key) {
        if (!this.existsStr(key)) {
            return 0L;
        }
        return (Long)this.strRedisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                long result = 0L;
                result = connection.del((byte[][])new byte[][]{key.getBytes()});
                return result;
            }
        });
    }

    @Override
    public boolean exists(final String key) {
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exists(key.getBytes());
            }
        });
    }

    @Override
    public boolean existsStr(final String key) {
        return (Boolean)this.strRedisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exists(key.getBytes());
            }
        });
    }

    @Override
    public void addSet(String key, E[] objs) {
        SetOperations set = this.redisTemplate.opsForSet();
        for (E obj : objs) {
            set.add((Object)key, new Object[]{obj});
        }
    }

    @Override
    public void addSet(String key, Set<E> list) {
        this.addSet(key, (E)list.toArray());
    }

    @Override
    public void addSet(String key, E value) {
        this.redisTemplate.opsForSet().add((Object)key, new Object[]{value});
    }

    @Override
    public void addList(String key, List<E> objList) {
        ListOperations list = this.redisTemplate.opsForList();
        for (E obj : objList) {
            list.leftPush((Object)key, obj);
        }
    }

    @Override
    public boolean contains(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    @Override
    public void removeSetValue(String key, Object value) {
        this.redisTemplate.opsForSet().remove((Object)key, new Object[]{value});
    }

    @Override
    public boolean addStr(final String key, final String value) {
        if (this.existsStr(key)) {
            this.updateStr(key, value);
        }
        boolean result = (Boolean)this.strRedisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisCacheServiceImpl.this.getRedisSerializer();
                byte[] keys = serializer.serialize((Object)key);
                byte[] values = serializer.serialize((Object)value);
                return connection.setNX(keys, values);
            }
        });
        return result;
    }

    @Override
    public boolean updateStr(final String key, final String value) {
        if (!this.exists(key)) {
            return this.addStr(key, value);
        }
        return (Boolean)this.strRedisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisCacheServiceImpl.this.getRedisSerializer();
                byte[] keys = serializer.serialize((Object)key);
                byte[] values = serializer.serialize((Object)value);
                connection.set(keys, values);
                return true;
            }
        });
    }

    @Override
    public String getStr(final String key) {
        String result = (String)this.strRedisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisCacheServiceImpl.this.getRedisSerializer();
                byte[] keys = serializer.serialize((Object)key);
                byte[] values = connection.get(keys);
                if (values == null) {
                    return null;
                }
                String value = (String)serializer.deserialize(values);
                return value;
            }
        });
        return result == null ? "" : result;
    }

    private RedisSerializer<String> getRedisSerializer() {
        return this.strRedisTemplate.getStringSerializer();
    }

    @Override
    public Long removeFuzzy(final String key) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                long result = 0L;
                Set keys = connection.keys(key.getBytes());
                for (byte[] keySet : keys) {
                    result += connection.del((byte[][])new byte[][]{keySet}).longValue();
                }
                return result;
            }
        });
    }

    @Override
    public Set<E> getSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public boolean expire(final String key, final int timeout) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.expire(key.getBytes(), (long)timeout).booleanValue()) {
                    return 200L;
                }
                return 300L;
            }
        }) == 200L;
    }

    @Override
    public boolean expireStr(final String key, final int timeout) {
        return (Long)this.strRedisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.expire(key.getBytes(), (long)timeout).booleanValue()) {
                    return 200L;
                }
                return 300L;
            }
        }) == 200L;
    }

    @Override
    public long incrAdd(String key) {
        return this.redisTemplate.boundValueOps((Object)key).increment(1L);
    }

    @Override
    public long incrAdd(String key, int value) {
        return this.redisTemplate.boundValueOps((Object)key).increment((long)value);
    }

    @Override
    public long incrSub(String key) {
        return this.redisTemplate.boundValueOps((Object)key).increment(-1L);
    }

    @Override
    public void convertAndSend(String channel, String message) {
        this.redisTemplate.convertAndSend(channel, (Object)message);
    }

    @Override
    public Long getForListSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    @Override
    public void leftPush(String key, E value) {
        this.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    @Override
    public void rightPush(String key, E value) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    @Override
    public E getBLPop(final String key) {
        return (E)this.redisTemplate.execute(new RedisCallback<E>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E doInRedis(RedisConnection connection) throws DataAccessException {
                try {
                    RedisCacheServiceImpl.this.lock.lockInterruptibly();
                    List results = connection.bLPop(0, (byte[][])new byte[][]{key.getBytes()});
                    if (CollectionUtils.isEmpty((Collection)results)) {
                        Object e = null;
                        return e;
                    }
                    Object object = RedisCacheServiceImpl.this.getRedisSerializer().deserialize((byte[])results.get(1));
                    return object;
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    RedisCacheServiceImpl.this.lock.unlock();
                }
                return null;
            }
        });
    }

    @Override
    public E getBRPop(final String key) {
        return (E)this.redisTemplate.execute(new RedisCallback<E>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E doInRedis(RedisConnection connection) throws DataAccessException {
                try {
                    RedisCacheServiceImpl.this.lock.lockInterruptibly();
                    List results = connection.bRPop(0, (byte[][])new byte[][]{key.getBytes()});
                    if (CollectionUtils.isEmpty((Collection)results)) {
                        Object e = null;
                        return e;
                    }
                    RedisSerializer redisSerializer = RedisCacheServiceImpl.this.redisTemplate.getValueSerializer();
                    Object object = redisSerializer.deserialize((byte[])results.get(1));
                    return object;
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    RedisCacheServiceImpl.this.lock.unlock();
                }
                return null;
            }
        });
    }

    @Override
    public Set<String> getFuzzy(String matchKey) {
        Set keys = (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> keysTmp = new HashSet<String>();
            Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().match("*" + matchKey + "*").count(1000L).build());
            while (cursor.hasNext()) {
                keysTmp.add(new String((byte[])cursor.next()));
            }
            return keysTmp;
        });
        return keys;
    }

    public RedisTemplate<String, E> getRedisTemplate() {
        return this.redisTemplate;
    }

    public RedisTemplate<String, String> getStrRedisTemplate() {
        return this.strRedisTemplate;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setRedisTemplate(RedisTemplate<String, E> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setStrRedisTemplate(RedisTemplate<String, String> strRedisTemplate) {
        this.strRedisTemplate = strRedisTemplate;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisCacheServiceImpl)) {
            return false;
        }
        RedisCacheServiceImpl other = (RedisCacheServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, E> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, E> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        RedisTemplate<String, String> this$strRedisTemplate = this.getStrRedisTemplate();
        RedisTemplate<String, String> other$strRedisTemplate = other.getStrRedisTemplate();
        if (this$strRedisTemplate == null ? other$strRedisTemplate != null : !this$strRedisTemplate.equals(other$strRedisTemplate)) {
            return false;
        }
        Lock this$lock = this.getLock();
        Lock other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisCacheServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, E> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        RedisTemplate<String, String> $strRedisTemplate = this.getStrRedisTemplate();
        result = result * 59 + ($strRedisTemplate == null ? 43 : $strRedisTemplate.hashCode());
        Lock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }

    public String toString() {
        return "RedisCacheServiceImpl(redisTemplate=" + this.getRedisTemplate() + ", strRedisTemplate=" + this.getStrRedisTemplate() + ", lock=" + this.getLock() + ")";
    }
}

