/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.aop;

import com.fhs.trans.service.impl.TransService;
import com.fhs.trans.utils.TransUtil;
import java.util.ArrayList;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Aspect
public class TransMethodResultAop
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TransMethodResultAop.class);
    @Value(value="${easy-trans.is-enable-tile:false}")
    private Boolean isEnableTile;
    @Value(value="${easy-trans.is-enable-map-result:false}")
    private Boolean isEnableMapResult;
    @Autowired
    private TransService transService;

    @Around(value="@annotation(com.fhs.core.trans.anno.TransMethodResult)")
    public Object transResult(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = null;
        proceed = joinPoint.proceed();
        try {
            return TransUtil.transOne(proceed, this.transService, this.isEnableTile, new ArrayList<Object>());
        }
        catch (Exception e) {
            log.error("\u7ffb\u8bd1\u9519\u8bef", (Throwable)e);
            return proceed;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isEnableMapResult.booleanValue()) {
            TransUtil.transResultMap = true;
        }
    }
}

