/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.filter;

import com.fhs.core.trans.vo.VO;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.springframework.core.annotation.Order;

@Order(value=0)
@WebFilter(filterName="releaseTransCacheFilter", urlPatterns={"/*"})
public class ReleaseTransCacheFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Cache cache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
            VO.TRANS_MAP_CACHE.set(cache.asMap());
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            VO.TRANS_MAP_CACHE.set(null);
        }
    }

    public void destroy() {
    }
}

