/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.cache.service.RedisCacheService;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.fi.LocaleGetter;
import com.fhs.trans.service.impl.ITransTypeService;
import com.fhs.trans.service.impl.TransService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DictionaryTransService
implements ITransTypeService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryTransService.class);
    private static final String TRANS_PRE = "trans:";
    @Autowired(required=false)
    private RedisCacheService<String> redisCacheService;
    private Map<String, String> dictionaryTransMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> unTransMap = new ConcurrentHashMap<String, String>();
    private boolean isOpenI18n;
    private LocaleGetter localeGetter;
    @Value(value="${easy-trans.dict-use-redis:false}")
    private boolean isUseRedis;

    public void refreshCache(String dictGroupCode, Map<String, String> dicMap) {
        if (this.isUseRedis && this.redisCacheService == null) {
            throw new RuntimeException("\u4f7f\u7528redis \u8bf7\u5c06 easy-trans.is-enable-redis \u8bbe\u7f6e\u4e3atrue");
        }
        dicMap.keySet().forEach(dictCode -> {
            if (!this.isUseRedis) {
                this.dictionaryTransMap.put(dictGroupCode + "_" + dictCode, (String)dicMap.get(dictCode));
            } else {
                this.redisCacheService.put(TRANS_PRE + dictGroupCode + "_" + dictCode, (String)dicMap.get(dictCode));
            }
            this.unTransMap.put(dictGroupCode + "_" + (String)dicMap.get(dictCode), (String)dictCode);
        });
    }

    public Map<String, String> getDictionaryTransMap() {
        return this.dictionaryTransMap;
    }

    @Override
    public void transOne(VO obj, List<Field> toTransList) {
        Trans tempTrans = null;
        for (Field tempField : toTransList) {
            String transResult;
            tempField.setAccessible(true);
            tempTrans = tempField.getAnnotation(Trans.class);
            String dicCodes = StringUtil.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
            if (dicCodes.contains(",")) {
                dicCodes = dicCodes.replace("[", "").replace("]", "").replace(" ", "");
            }
            String[] dicCodeArray = dicCodes.split(",");
            String key = tempTrans.key().contains("KEY_") ? StringUtil.toString(ReflectUtils.getValue((Object)obj, (String)tempTrans.key().replace("KEY_", ""))) : tempTrans.key();
            ArrayList<String> dicCodeList = new ArrayList<String>();
            for (String dicCode : dicCodeArray) {
                if (StringUtil.isEmpty(dicCode)) continue;
                if (!this.isUseRedis) {
                    dicCodeList.add(this.dictionaryTransMap.get(this.getMapKey(key, dicCode)));
                    continue;
                }
                dicCodeList.add(this.redisCacheService.get(TRANS_PRE + this.getMapKey(key, dicCode)));
            }
            String string = transResult = dicCodeList.size() > 0 ? StringUtil.getStrForIn(dicCodeList, false) : "";
            if (obj.getTransMap() != null) {
                obj.getTransMap().put(tempField.getName() + "Name", transResult);
            }
            this.setRef(tempTrans, obj, transResult);
        }
    }

    public String getMapKey(String dictGroupCode, String dictCode) {
        if (this.isOpenI18n) {
            return dictGroupCode + "_" + dictCode + "_" + this.localeGetter.getLanguageTag();
        }
        return dictGroupCode + "_" + dictCode;
    }

    @Override
    public void transMore(List<? extends VO> objList, List<Field> toTransList) {
        for (VO vO : objList) {
            this.transOne(vO, toTransList);
        }
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("dictionary", this);
    }

    public void openI18n(LocaleGetter localeGetter) {
        this.isOpenI18n = true;
        this.localeGetter = localeGetter;
    }

    public void makeUseRedis() {
        this.isUseRedis = true;
        if (this.redisCacheService == null) {
            throw new RuntimeException("\u4f7f\u7528redis \u8bf7\u5c06 easy-trans.is-enable-redis \u8bbe\u7f6e\u4e3atrue");
        }
    }

    public Map<String, String> getUnTransMap() {
        return this.unTransMap;
    }
}

