/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.common.utils.CheckUtils;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.TransPojo;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.ds.DataSourceSetter;
import com.fhs.trans.service.impl.ITransTypeService;
import com.fhs.trans.service.impl.TransService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class SimpleTransService
implements ITransTypeService,
InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(SimpleTransService.class);
    private ThreadLocal<Map<String, Map<String, Object>>> threadLocalCache = new ThreadLocal();
    protected SimpleTransDiver transDiver;
    protected DataSourceSetter dataSourceSetter;
    protected Map<String, TransCacheSett> transCacheSettMap = new HashMap<String, TransCacheSett>();

    public void regsiterTransDiver(SimpleTransDiver transDiver) {
        this.transDiver = transDiver;
    }

    @Override
    public void transOne(VO obj, List<Field> toTransList) {
        Trans tempTrans = null;
        for (Field tempField : toTransList) {
            tempTrans = tempField.getAnnotation(Trans.class);
            String alias = tempTrans.alias();
            String pkey = ConverterUtils.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
            if (StringUtils.isEmpty((Object)pkey)) continue;
            HashMap<String, String> transCache = null;
            pkey = pkey.replace("[", "").replace("]", "");
            Map<String, Object> tempTransCache = null;
            if (pkey.contains(",")) {
                String[] pkeys = pkey.split(",");
                transCache = new LinkedHashMap();
                for (String tempPkey : pkeys) {
                    tempTransCache = this.getTempTransCacheMap(tempTrans, tempPkey);
                    if (tempTransCache == null || tempTransCache.isEmpty()) {
                        LOGGER.warn(this.getClass().getName() + "\u7ffb\u8bd1\u672a\u547d\u4e2d\u6570\u636e:" + tempTrans.target().getName() + "_" + tempPkey);
                        continue;
                    }
                    for (String key : tempTransCache.keySet()) {
                        transCache.put(key, transCache.containsKey(key) ? (String)transCache.get(key) + "," + tempTransCache.get(key) : StringUtil.toString(tempTransCache.get(key)));
                    }
                }
            } else {
                transCache = new HashMap<String, String>(1);
                tempTransCache = this.getTempTransCacheMap(tempTrans, ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
                if (tempTransCache == null || tempTransCache.isEmpty()) {
                    LOGGER.warn(this.getClass().getName() + "\u7ffb\u8bd1\u672a\u547d\u4e2d\u6570\u636e:" + tempTrans.target().getName() + "_" + ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
                    continue;
                }
                HashMap<String, String> finalTransCache = transCache;
                tempTransCache.forEach((k, v) -> {
                    if (!"targetObject".equals(k)) {
                        finalTransCache.put((String)k, StringUtil.toString(v));
                    }
                });
            }
            this.setRef(tempTrans, obj, transCache, (VO)tempTransCache.get("targetObject"));
            Map transMap = obj.getTransMap();
            if (transMap == null) continue;
            if (!CheckUtils.isNullOrEmpty(alias)) {
                HashMap tempMap = new HashMap();
                Set keys = transCache.keySet();
                for (String key : keys) {
                    tempMap.put(alias + key.substring(0, 1).toUpperCase() + key.substring(1), transCache.get(key));
                }
                transCache = tempMap;
            }
            Set keys = transCache.keySet();
            for (String key : keys) {
                if (!CheckUtils.isNullOrEmpty(transMap.get(key))) continue;
                transMap.put(key, transCache.get(key));
            }
        }
    }

    @Override
    public void transMore(List<? extends VO> objList, List<Field> toTransList) {
        this.threadLocalCache.set(new HashMap());
        HashMap namespaceFieldsGroupMap = new HashMap();
        for (Field tempField : toTransList) {
            tempField.setAccessible(true);
            Trans tempTrans = tempField.getAnnotation(Trans.class);
            String targetClassName = this.getTargetClassName(tempTrans);
            List<Field> fields = namespaceFieldsGroupMap.containsKey(targetClassName) ? (List)namespaceFieldsGroupMap.get(targetClassName) : new ArrayList();
            fields.add(tempField);
            namespaceFieldsGroupMap.put(targetClassName, fields);
        }
        for (String target : namespaceFieldsGroupMap.keySet()) {
            List fields = (List)namespaceFieldsGroupMap.get(target);
            Trans tempTrans = ((Field)fields.get(0)).getAnnotation(Trans.class);
            HashSet<Object> ids = new HashSet<Object>();
            objList.forEach(obj -> {
                for (Field field : fields) {
                    try {
                        Object tempId = field.get(obj);
                        if (!CheckUtils.isNotEmpty(tempId)) continue;
                        String pkey = ConverterUtils.toString(tempId).replace("[", "").replace("]", "");
                        if (pkey.contains(",")) {
                            String[] pkeys;
                            for (String id : pkeys = pkey.split(",")) {
                                ids.add(id);
                            }
                            continue;
                        }
                        ids.add(tempId);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (ids.isEmpty()) continue;
            if (this.transCacheSettMap.containsKey(this.getTargetClassName(tempTrans))) {
                Set<Object> newIds = this.initLocalFromGlobalCache(this.threadLocalCache, ids, this.getTargetClassName(tempTrans), "simple");
                ids.clear();
                ids.addAll(newIds);
            }
            if (ids.isEmpty()) continue;
            List<? extends VO> dbDatas = this.findByIds(new ArrayList(ids), tempTrans);
            for (VO vO : dbDatas) {
                this.threadLocalCache.get().put(this.getTargetClassName(tempTrans) + "_" + this.getUniqueKey(vO, tempTrans), this.createTempTransCacheMap(vO, tempTrans));
            }
        }
        objList.forEach(obj -> this.transOne((VO)obj, toTransList));
        this.threadLocalCache.set(null);
    }

    public Object getUniqueKey(VO vo, Trans tempTrans) {
        if (StringUtils.isEmpty((Object)tempTrans.uniqueField())) {
            return vo.getPkey();
        }
        return ReflectUtils.getValue((Object)vo, (String)tempTrans.uniqueField());
    }

    public List<? extends VO> findByIds(List ids, Trans tempTrans) {
        return this.findByIds(() -> this.transDiver.findByIds(ids, tempTrans.target(), tempTrans.uniqueField()), tempTrans.dataSource());
    }

    public VO findById(Object id, Trans tempTrans) {
        return this.findById(() -> this.transDiver.findById((Serializable)id, tempTrans.target(), tempTrans.uniqueField()), tempTrans.dataSource());
    }

    private Map<String, Object> getTempTransCacheMap(Trans tempTrans, Object pkey) {
        String className = this.getTargetClassName(tempTrans);
        if (this.transCacheSettMap.containsKey(className) && this.getFromGlobalCache(pkey, className, "simple") != null) {
            return this.getFromGlobalCache(pkey, className, "simple");
        }
        if (this.threadLocalCache.get() == null) {
            if (CheckUtils.isNullOrEmpty(pkey)) {
                return new HashMap<String, Object>();
            }
            VO vo = this.findById(pkey, tempTrans);
            return this.createTempTransCacheMap(vo, tempTrans);
        }
        return this.threadLocalCache.get().get(this.getTargetClassName(tempTrans) + "_" + pkey);
    }

    protected String getTargetClassName(Trans tempTrans) {
        return tempTrans.target() == TransPojo.class ? tempTrans.targetClassName() : tempTrans.target().getName();
    }

    protected Map<String, Object> createTempTransCacheMap(VO po, Trans trans) {
        String fielVal = null;
        LinkedHashMap<String, Object> tempCacheTransMap = new LinkedHashMap<String, Object>();
        if (po == null) {
            return tempCacheTransMap;
        }
        for (String field : trans.fields()) {
            fielVal = ConverterUtils.toString(ReflectUtils.getValue((Object)po, (String)field));
            tempCacheTransMap.put(field, fielVal);
        }
        tempCacheTransMap.put("targetObject", po);
        String className = this.getTargetClassName(trans);
        if (this.transCacheSettMap.containsKey(className)) {
            TransCacheSett cacheSett = this.transCacheSettMap.get(className);
            this.put2GlobalCache(tempCacheTransMap, cacheSett.isAccess(), cacheSett.getCacheSeconds(), cacheSett.getMaxCache(), po.getPkey(), className, "simple");
        }
        return tempCacheTransMap;
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("simple", this);
    }

    public void setTransCache(Object type, TransCacheSett cacheSett) {
        Class typeClass = (Class)type;
        this.transCacheSettMap.put(typeClass.getName(), cacheSett);
    }

    public static class TransCacheSett {
        private boolean isAccess = false;
        private long cacheSeconds = 5L;
        private int maxCache = 1000;

        public static TransCacheSettBuilder builder() {
            return new TransCacheSettBuilder();
        }

        public boolean isAccess() {
            return this.isAccess;
        }

        public long getCacheSeconds() {
            return this.cacheSeconds;
        }

        public int getMaxCache() {
            return this.maxCache;
        }

        public void setAccess(boolean isAccess) {
            this.isAccess = isAccess;
        }

        public void setCacheSeconds(long cacheSeconds) {
            this.cacheSeconds = cacheSeconds;
        }

        public void setMaxCache(int maxCache) {
            this.maxCache = maxCache;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransCacheSett)) {
                return false;
            }
            TransCacheSett other = (TransCacheSett)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAccess() != other.isAccess()) {
                return false;
            }
            if (this.getCacheSeconds() != other.getCacheSeconds()) {
                return false;
            }
            return this.getMaxCache() == other.getMaxCache();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransCacheSett;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAccess() ? 79 : 97);
            long $cacheSeconds = this.getCacheSeconds();
            result = result * 59 + (int)($cacheSeconds >>> 32 ^ $cacheSeconds);
            result = result * 59 + this.getMaxCache();
            return result;
        }

        public String toString() {
            return "SimpleTransService.TransCacheSett(isAccess=" + this.isAccess() + ", cacheSeconds=" + this.getCacheSeconds() + ", maxCache=" + this.getMaxCache() + ")";
        }

        public TransCacheSett() {
        }

        public TransCacheSett(boolean isAccess, long cacheSeconds, int maxCache) {
            this.isAccess = isAccess;
            this.cacheSeconds = cacheSeconds;
            this.maxCache = maxCache;
        }

        public static class TransCacheSettBuilder {
            private boolean isAccess;
            private long cacheSeconds;
            private int maxCache;

            TransCacheSettBuilder() {
            }

            public TransCacheSettBuilder isAccess(boolean isAccess) {
                this.isAccess = isAccess;
                return this;
            }

            public TransCacheSettBuilder cacheSeconds(long cacheSeconds) {
                this.cacheSeconds = cacheSeconds;
                return this;
            }

            public TransCacheSettBuilder maxCache(int maxCache) {
                this.maxCache = maxCache;
                return this;
            }

            public TransCacheSett build() {
                return new TransCacheSett(this.isAccess, this.cacheSeconds, this.maxCache);
            }

            public String toString() {
                return "SimpleTransService.TransCacheSett.TransCacheSettBuilder(isAccess=" + this.isAccess + ", cacheSeconds=" + this.cacheSeconds + ", maxCache=" + this.maxCache + ")";
            }
        }
    }

    public static interface SimpleTransDiver {
        public List<? extends VO> findByIds(List<? extends Serializable> var1, Class<? extends VO> var2, String var3);

        public VO findById(Serializable var1, Class<? extends VO> var2, String var3);
    }
}

