/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.core.trans.vo.VO;
import com.fhs.trans.manager.ClassInfo;
import com.fhs.trans.manager.ClassManager;
import com.fhs.trans.service.impl.ITransTypeService;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class TransService {
    private static Logger logger = LoggerFactory.getLogger(TransService.class);
    private static Map<String, ITransTypeService> transTypeServiceMap = new HashMap<String, ITransTypeService>();

    public static void registerTransType(String type, ITransTypeService transTypeService) {
        transTypeServiceMap.put(type, transTypeService);
    }

    public void transOne(VO obj) {
        if (obj == null) {
            return;
        }
        ClassInfo info = ClassManager.getClassInfoByName(obj.getClass());
        String[] transTypes = info.getTransTypes();
        if (transTypes == null) {
            return;
        }
        List<Field> transFieldList = null;
        for (String type : transTypes) {
            transFieldList = info.getTransField(type);
            if (transFieldList == null || transFieldList.size() == 0) continue;
            transTypeServiceMap.get(type).transOne(obj, transFieldList);
        }
    }

    public void transMore(List<? extends VO> objList) {
        if (objList == null || objList.size() == 0) {
            return;
        }
        VO object = objList.get(0);
        ClassInfo info = ClassManager.getClassInfoByName(object.getClass());
        String[] transTypes = info.getTransTypes();
        if (transTypes == null) {
            return;
        }
        List<Field> transFieldList = null;
        for (String type : transTypes) {
            transFieldList = info.getTransField(type);
            if (transFieldList == null || transFieldList.size() == 0) continue;
            ITransTypeService transTypeService = transTypeServiceMap.get(type);
            if (ObjectUtils.isEmpty((Object)transTypeService)) {
                logger.warn("\u6ca1\u6709\u5339\u914d\u7684\u8f6c\u6362\u5668:" + type);
                continue;
            }
            transTypeService.transMore(objList, transFieldList);
        }
    }

    public void transBatch(List<? extends VO> objList) {
        this.transMore(objList);
    }
}

