/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.beans.BeanGenerator;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyAppender {
    private static final Logger log = LoggerFactory.getLogger(PropertyAppender.class);

    PropertyAppender() {
    }

    public static Object generate(Object dest, Map<String, Object> newValueMap) throws InvocationTargetException, IllegalAccessException {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        PropertyDescriptor[] descriptorArr = propertyUtilsBean.getPropertyDescriptors(dest);
        HashMap oldKeyMap = new HashMap(4);
        for (PropertyDescriptor it : descriptorArr) {
            if ("class".equalsIgnoreCase(it.getName())) continue;
            oldKeyMap.put(it.getName(), it.getPropertyType());
            newValueMap.put(it.getName(), it.getReadMethod().invoke(dest, new Object[0]));
        }
        newValueMap.forEach((k, v) -> {
            if (v != null) {
                oldKeyMap.put((String)k, v.getClass());
            }
        });
        DynamicBean dynamicBean = new DynamicBean(dest.getClass(), oldKeyMap);
        newValueMap.forEach((k, v) -> {
            try {
                dynamicBean.setValue(k, v);
            }
            catch (Exception e) {
                log.error("\u52a8\u6001\u6dfb\u52a0\u5b57\u6bb5\u3010\u503c\u3011\u51fa\u9519", (Throwable)e);
            }
        });
        return dynamicBean.getTarget();
    }

    private static final class DynamicBean {
        private Object target;
        private BeanMap beanMap;

        private DynamicBean(Class superclass, Map<String, Class> propertyMap) {
            this.target = this.generateBean(superclass, propertyMap);
            this.beanMap = BeanMap.create((Object)this.target);
        }

        private void setValue(String property, Object value) {
            this.beanMap.put((Object)property, value);
        }

        private Object getValue(String property) {
            return this.beanMap.get((Object)property);
        }

        private Object getTarget() {
            return this.target;
        }

        private Object generateBean(Class superclass, Map<String, Class> propertyMap) {
            BeanGenerator generator = new BeanGenerator();
            if (null != superclass) {
                generator.setSuperclass(superclass);
            }
            BeanGenerator.addProperties((BeanGenerator)generator, propertyMap);
            return generator.create();
        }
    }
}

