/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.utils;

import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.service.impl.TransService;
import com.fhs.trans.utils.PropertyAppender;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransUtil {
    private static final Logger log = LoggerFactory.getLogger(TransUtil.class);
    public static boolean transResultMap = false;

    public static Collection transBatch(Object object, TransService transService, boolean isProxy, ArrayList<Object> hasTransObjs) throws IllegalAccessException, InstantiationException {
        Collection param = (Collection)object;
        if (param == null) {
            return null;
        }
        if (param.isEmpty()) {
            return param;
        }
        boolean isVo = false;
        if (param.iterator().next() instanceof VO) {
            transService.transMore(new ArrayList(param));
            isVo = true;
        } else {
            for (Object tempObject : param) {
                TransUtil.transOne(tempObject, transService, isProxy, hasTransObjs);
            }
        }
        if (!isProxy || !isVo) {
            return (Collection)object;
        }
        AbstractCollection result = null;
        if (param instanceof List) {
            result = new ArrayList();
        } else if (param instanceof Set) {
            result = new HashSet();
        } else {
            return param;
        }
        for (Object vo : param) {
            if (TransUtil.contains(hasTransObjs, vo)) continue;
            hasTransObjs.add(vo);
            result.add(TransUtil.createProxyVoForJackson((VO)vo));
        }
        return result;
    }

    private static boolean contains(List<Object> list, Object obj) {
        for (Object o : list) {
            if (o != obj) continue;
            return true;
        }
        return false;
    }

    public static Object transOne(Object object, TransService transService, boolean isProxy, ArrayList<Object> hasTransObjs) throws IllegalAccessException, InstantiationException {
        if (object == null) {
            return null;
        }
        if (TransUtil.contains(hasTransObjs, object)) {
            return object;
        }
        hasTransObjs.add(object);
        boolean isVo = false;
        if (transResultMap && object instanceof Map) {
            Map tempMap = (Map)object;
            for (Object mapValue : tempMap.values()) {
                TransUtil.transOne(mapValue, transService, isProxy, hasTransObjs);
            }
            return object;
        }
        if (object instanceof VO) {
            transService.transOne((VO)object);
            isVo = true;
        } else {
            if (object instanceof Collection) {
                return TransUtil.transBatch(object, transService, isProxy, hasTransObjs);
            }
            if (object.getClass().getName().startsWith("java.")) {
                return object;
            }
            List fields = ReflectUtils.getAllField((Object)object);
            Object tempObj = null;
            for (Field field : fields) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                tempObj = field.get(object);
                try {
                    field.set(object, TransUtil.transOne(tempObj, transService, isProxy, hasTransObjs));
                }
                catch (Exception e) {
                    log.error("\u5982\u679c\u5b57\u6bb5set\u9519\u8bef\uff0c\u8bf7\u53cd\u9988\u7ed9easytrans\u5f00\u53d1\u8005", (Throwable)e);
                }
            }
        }
        return isProxy && isVo ? TransUtil.createProxyVoForJackson((VO)object) : object;
    }

    public static Object createProxyVoForJackson(VO vo) {
        if (vo == null || vo.getTransMap() == null) {
            return vo;
        }
        try {
            Map transMap = vo.getTransMap();
            HashMap<String, Object> copyMap = new HashMap<String, Object>();
            for (Object key : transMap.keySet()) {
                copyMap.put((String)key, transMap.get(key));
            }
            copyMap.put("transMap", null);
            return PropertyAppender.generate(vo, copyMap);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return vo;
    }
}

