/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.buffer;

import com.gettyio.core.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public class AutoByteBuffer {
    public static final int BUFFER_SIZE = 256;
    private int readerIndex;
    private int writerIndex;
    private byte[] data;

    private AutoByteBuffer(int capacity) {
        this.data = new byte[capacity];
    }

    public static AutoByteBuffer newByteBuffer() {
        return new AutoByteBuffer(256);
    }

    public static AutoByteBuffer newByteBuffer(int capacity) {
        return new AutoByteBuffer(capacity);
    }

    public AutoByteBuffer readerIndex(int position) {
        this.readerIndex = position <= this.writerIndex ? position : this.writerIndex;
        return this;
    }

    public byte[] array() {
        return this.data;
    }

    public AutoByteBuffer clear() {
        this.readerIndex = 0;
        this.writerIndex = 0;
        this.data = new byte[256];
        return this;
    }

    public AutoByteBuffer reset() {
        this.readerIndex = 0;
        this.writerIndex = 0;
        return this;
    }

    public byte[] readableBytesArray() {
        byte[] bytes = new byte[this.readableBytes()];
        this.readBytesFromBytes(this.data, bytes, this.readerIndex);
        return bytes;
    }

    public byte[] allWriteBytesArray() {
        byte[] bytes = new byte[this.writerIndex];
        this.readBytesFromBytes(this.data, bytes, 0);
        return bytes;
    }

    public void discardReadBytes() {
        byte[] newBytes = new byte[this.capacity()];
        int oldReadableBytes = this.readableBytes();
        System.arraycopy(this.data, this.readerIndex, newBytes, 0, oldReadableBytes);
        this.writerIndex = oldReadableBytes;
        this.readerIndex = 0;
        this.data = newBytes;
    }

    public int readerIndex() {
        return this.readerIndex;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    public boolean hasRemaining() {
        return this.writerIndex - this.readerIndex > 0;
    }

    public boolean hasArray() {
        return this.writerIndex > 0;
    }

    public int writableBytes() {
        return this.data.length - this.writerIndex;
    }

    public int capacity() {
        return this.data.length;
    }

    public int read() throws ByteBufferException {
        if (this.readableBytes() > 0) {
            byte i = this.data[this.readerIndex];
            ++this.readerIndex;
            return i;
        }
        throw new ByteBufferException("readableBytes = 0");
    }

    public byte read(int index) throws ByteBufferException {
        if (this.writerIndex() > index) {
            byte i = this.data[index];
            return i;
        }
        throw new ByteBufferException("IndexOutOfBoundsException");
    }

    public byte readByte() throws ByteBufferException {
        if (this.readableBytes() > 0) {
            byte i = this.data[this.readerIndex];
            ++this.readerIndex;
            return i;
        }
        throw new ByteBufferException("readableBytes = 0");
    }

    public short readUnsignedByte() throws ByteBufferException {
        return (short)(this.readByte() & 0xFF);
    }

    public int readInt() throws ByteBufferException {
        if (this.readableBytes() >= 4) {
            int result = this.byteArrayToInt(this.data, this.readerIndex);
            this.readerIndex += 4;
            return result;
        }
        throw new ByteBufferException("readableBytes < 4");
    }

    public int readBytes(byte[] bytes) throws ByteBufferException {
        if (this.readableBytes() >= bytes.length) {
            int result = this.readBytesFromBytes(this.data, bytes, this.readerIndex);
            this.readerIndex += bytes.length;
            return result;
        }
        throw new ByteBufferException("readableBytes < " + bytes.length);
    }

    public int readBytes(byte[] bytes, int offset, int length) throws ByteBufferException {
        if (this.readableBytes() >= length) {
            int result = this.readBytesFromBytes(this.data, bytes, this.readerIndex, offset, length);
            this.readerIndex += length;
            return result;
        }
        throw new ByteBufferException("readableBytes < " + length);
    }

    public int readBytes(AutoByteBuffer b) {
        byte[] bytes = new byte[b.writableBytes()];
        int result = this.readBytesFromBytes(this.data, bytes, this.readerIndex);
        this.readerIndex += bytes.length;
        b.writeBytes(bytes);
        return result;
    }

    public AutoByteBuffer readRetainedSlice(int len) throws ByteBufferException {
        byte[] bytes = new byte[len];
        this.readBytes(bytes);
        AutoByteBuffer b = AutoByteBuffer.newByteBuffer(len).writeBytes(bytes);
        return b;
    }

    public AutoByteBuffer writeByte(byte b) {
        this.autoExpandCapacity(1);
        this.data[this.writerIndex] = b;
        ++this.writerIndex;
        return this;
    }

    public AutoByteBuffer write(int b) {
        this.autoExpandCapacity(1);
        this.data[this.writerIndex] = (byte)(0xFF & b);
        ++this.writerIndex;
        return this;
    }

    public AutoByteBuffer writeInt(int b) {
        this.autoExpandCapacity(4);
        this.writeBytesToBytes(this.intToByteArray(b), this.data, this.writerIndex);
        this.writerIndex += 4;
        return this;
    }

    public AutoByteBuffer writeShort(int value) {
        this.autoExpandCapacity(2);
        this.writeBytesToBytes(this.shortToByte(value), this.data, this.writerIndex);
        this.writerIndex += 2;
        return this;
    }

    public AutoByteBuffer writeBytes(byte[] b) {
        this.autoExpandCapacity(b.length);
        this.writeBytesToBytes(b, this.data, this.writerIndex);
        this.writerIndex += b.length;
        return this;
    }

    public AutoByteBuffer writeBytes(byte[] b, int len) {
        this.autoExpandCapacity(b.length);
        this.writeBytesToBytes(b, this.data, this.writerIndex, len);
        this.writerIndex += len;
        return this;
    }

    public AutoByteBuffer writeBytes(byte[] src, int srcIndex, int len) {
        this.autoExpandCapacity(len);
        System.arraycopy(src, srcIndex, this.data, this.writerIndex, len);
        this.writerIndex += len;
        return this;
    }

    public AutoByteBuffer writeBytes(AutoByteBuffer b) {
        int readableBytes = b.readableBytes();
        this.autoExpandCapacity(readableBytes);
        this.writeBytesToBytes(b.readableBytesArray(), this.data, this.writerIndex);
        b.readerIndex(b.writerIndex);
        this.writerIndex += readableBytes;
        return this;
    }

    public AutoByteBuffer writeBytes(AutoByteBuffer b, int dataLength) {
        this.autoExpandCapacity(dataLength);
        this.writeBytesToBytes(b.readableBytesArray(), this.data, this.writerIndex, dataLength);
        b.readerIndex(b.readerIndex + dataLength);
        this.writerIndex += dataLength;
        return this;
    }

    private void autoExpandCapacity(int addLength) {
        if (this.writableBytes() < addLength) {
            int size;
            int newSize = this.writerIndex + addLength;
            for (size = 0; size < newSize; size += 256) {
            }
            byte[] newBytes = new byte[size];
            this.writeBytesToBytes(this.data, newBytes, 0);
            this.data = newBytes;
        }
    }

    private int byteArrayToInt(byte[] b, int position) {
        return b[position + 3] & 0xFF | (b[position + 2] & 0xFF) << 8 | (b[position + 1] & 0xFF) << 16 | (b[position] & 0xFF) << 24;
    }

    private int readBytesFromBytes(byte[] src, byte[] result, int position) {
        System.arraycopy(src, position, result, 0, result.length);
        return src.length;
    }

    private int readBytesFromBytes(byte[] src, byte[] result, int position, int offset, int length) {
        System.arraycopy(src, position, result, offset, length);
        return src.length;
    }

    private AutoByteBuffer writeBytesToBytes(byte[] src, byte[] target, int targetPosition) {
        return this.writeBytesToBytes(src, target, targetPosition, src.length);
    }

    private AutoByteBuffer writeBytesToBytes(byte[] src, byte[] target, int targetPosition, int dataLength) {
        System.arraycopy(src, 0, target, targetPosition, dataLength);
        return this;
    }

    public AutoByteBuffer duplicate() {
        AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer();
        autoByteBuffer.writeBytes(this);
        return autoByteBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBuffer{");
        sb.append("readerIndex=").append(this.readerIndex);
        sb.append(", writerIndex=").append(this.writerIndex);
        sb.append(", capacity=").append(this.data.length);
        sb.append('}');
        return sb.toString();
    }

    public String toString(int index, int length, Charset charset) {
        return this.decodeString(this, index, length, charset);
    }

    public byte[] getBytes(int start, int length) {
        byte[] bs = new byte[length];
        System.arraycopy(this, start, bs, 0, length);
        return bs;
    }

    public AutoByteBuffer skipBytes(int length) {
        this.readerIndex += length;
        return this;
    }

    public String decodeString(AutoByteBuffer src, int readerIndex, int len, Charset charset) {
        int offset;
        byte[] array;
        if (len == 0) {
            return "";
        }
        if (src.hasArray()) {
            array = src.array();
            offset = 0 + readerIndex;
        } else {
            offset = 0;
            array = this.getBytes(readerIndex, len);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(array, 0, offset, len);
        }
        return new String(array, offset, len, charset);
    }

    private byte[] intToByteArray(int i) {
        return new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
    }

    private byte[] shortToByte(int s) {
        byte[] targets = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return targets;
    }

    public static class ByteBufferException
    extends IOException {
        ByteBufferException(String message) {
            super(message);
        }
    }
}

