/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel;

import com.gettyio.core.buffer.AioBufferWriter;
import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.ChannelState;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.config.BaseConfig;
import com.gettyio.core.channel.internal.ReadCompletionHandler;
import com.gettyio.core.channel.internal.WriteCompletionHandler;
import com.gettyio.core.function.Function;
import com.gettyio.core.handler.ssl.SslHandler;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.pipeline.ChannelPipeline;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AioChannel
extends SocketChannel
implements Function<AioBufferWriter, Void> {
    protected AsynchronousSocketChannel channel;
    protected ByteBuffer readByteBuffer;
    protected ByteBuffer writeByteBuffer;
    private Semaphore semaphore = new Semaphore(1);
    private ReadCompletionHandler readCompletionHandler;
    private WriteCompletionHandler writeCompletionHandler;
    private SslHandler sslHandler;
    private IHandshakeCompletedListener handshakeCompletedListener;
    protected AioBufferWriter bufferWriter;
    private ChannelPipeline channelPipeline;
    int i = 0;

    public AioChannel(AsynchronousSocketChannel channel, BaseConfig config, ReadCompletionHandler readCompletionHandler, WriteCompletionHandler writeCompletionHandler, ChunkPool chunkPool, ChannelPipeline channelPipeline) {
        this.channel = channel;
        this.readCompletionHandler = readCompletionHandler;
        this.writeCompletionHandler = writeCompletionHandler;
        this.config = config;
        this.chunkPool = chunkPool;
        this.channelPipeline = channelPipeline;
        try {
            this.readByteBuffer = chunkPool.allocate(config.getReadBufferSize(), config.getChunkPoolBlockTime());
            channelPipeline.initChannel(this);
        }
        catch (Exception e) {
            try {
                channel.close();
            }
            catch (IOException e1) {
                logger.error(e1);
            }
            throw new RuntimeException("channelPipeline init exception", e);
        }
        this.bufferWriter = new AioBufferWriter(chunkPool, this, config.getBufferWriterQueueSize(), config.getChunkPoolBlockTime());
        try {
            this.invokePipeline(ChannelState.NEW_CHANNEL);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public void starRead() {
        this.initiateClose = false;
        this.continueRead();
        if (this.sslHandler != null) {
            this.sslHandler.getSslService().beginHandshake(this.handshakeCompletedListener);
        }
    }

    @Override
    public synchronized void close() {
        if (this.status == 1) {
            logger.warn("Channel:{} is closed", (Object)this.getChannelId());
            return;
        }
        if (this.readByteBuffer != null) {
            this.chunkPool.deallocate(this.readByteBuffer);
        }
        if (this.writeByteBuffer != null) {
            this.chunkPool.deallocate(this.writeByteBuffer);
        }
        if (this.channelFutureListener != null) {
            this.channelFutureListener.operationComplete(this);
        }
        try {
            if (!this.bufferWriter.isClosed()) {
                this.bufferWriter.close();
            }
            this.bufferWriter = null;
        }
        catch (IOException e) {
            logger.error(e);
        }
        try {
            this.channel.shutdownInput();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        try {
            this.channel.shutdownOutput();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            logger.error("close channel exception", e);
        }
        this.status = 1;
        try {
            this.invokePipeline(ChannelState.CHANNEL_CLOSED);
        }
        catch (Exception e) {
            logger.error("close channel exception", e);
        }
        if (this.defaultChannelPipeline != null) {
            this.defaultChannelPipeline.clean();
            this.defaultChannelPipeline = null;
        }
    }

    @Override
    public synchronized void close(boolean initiateClose) {
        this.initiateClose = initiateClose;
        this.close();
    }

    protected void continueRead() {
        if (this.status == 1) {
            return;
        }
        this.channel.read(this.readByteBuffer, this, this.readCompletionHandler);
    }

    public void readFromChannel(boolean eof) {
        ByteBuffer readBuffer = this.readByteBuffer;
        if (null != readBuffer) {
            readBuffer.flip();
            while (readBuffer.hasRemaining()) {
                byte[] bytes = new byte[readBuffer.remaining()];
                readBuffer.get(bytes, 0, bytes.length);
                try {
                    this.readToPipeline(bytes);
                }
                catch (Exception e) {
                    logger.error(e);
                    try {
                        this.invokePipeline(ChannelState.INPUT_EXCEPTION);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    this.close();
                }
            }
            if (eof) {
                this.close();
                return;
            }
            this.readCompleted(readBuffer);
        }
    }

    public void readCompleted(ByteBuffer readBuffer) {
        if (readBuffer == null) {
            return;
        }
        if (readBuffer.remaining() == 0) {
            readBuffer.clear();
        } else if (readBuffer.position() > 0) {
            readBuffer.compact();
        } else {
            readBuffer.position(readBuffer.limit());
            readBuffer.limit(readBuffer.capacity());
        }
        this.continueRead();
    }

    @Override
    public void writeAndFlush(Object obj) {
        try {
            this.reverseInvokePipeline(ChannelState.CHANNEL_WRITE, obj);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public void writeToChannel(Object obj) {
        try {
            this.bufferWriter.writeAndFlush((byte[])obj);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    private void continueWrite(ByteBuffer writeBuffer) {
        this.channel.write(writeBuffer, 0L, TimeUnit.MILLISECONDS, this, this.writeCompletionHandler);
    }

    public void writeCompleted() {
        if (this.writeByteBuffer == null) {
            this.writeByteBuffer = this.bufferWriter.poll();
        } else if (!this.writeByteBuffer.hasRemaining()) {
            this.chunkPool.deallocate(this.writeByteBuffer);
            this.writeByteBuffer = this.bufferWriter.poll();
        }
        if (this.writeByteBuffer != null) {
            this.continueWrite(this.writeByteBuffer);
            return;
        }
        this.semaphore.release();
        if (!this.keepAlive) {
            this.close();
        }
    }

    @Override
    public final InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public final InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("channel is closed");
        }
    }

    @Override
    public AsynchronousSocketChannel getAsynchronousSocketChannel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline getChannelPipeline() {
        return this.channelPipeline;
    }

    @Override
    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    @Override
    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    @Override
    public void setSslHandshakeCompletedListener(IHandshakeCompletedListener handshakeCompletedListener2) {
        this.handshakeCompletedListener = handshakeCompletedListener2;
    }

    @Override
    public Void apply(AioBufferWriter input) {
        if (this.semaphore.tryAcquire()) {
            this.writeByteBuffer = input.poll();
            if (null != this.writeByteBuffer) {
                this.continueWrite(this.writeByteBuffer);
            } else {
                this.semaphore.release();
            }
        }
        return null;
    }
}

