/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel;

import com.gettyio.core.channel.ChannelState;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.config.BaseConfig;
import com.gettyio.core.channel.loop.NioEventLoop;
import com.gettyio.core.handler.ssl.SslHandler;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.pipeline.ChannelPipeline;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;

public class NioChannel
extends SocketChannel {
    private java.nio.channels.SocketChannel channel;
    private SslHandler sslHandler;
    private IHandshakeCompletedListener handshakeCompletedListener;
    private ChannelPipeline channelPipeline;
    private NioEventLoop nioEventLoop;

    public NioChannel(BaseConfig config, java.nio.channels.SocketChannel channel, NioEventLoop nioEventLoop, ChannelPipeline channelPipeline) {
        this.config = config;
        this.channel = channel;
        this.channelPipeline = channelPipeline;
        this.nioEventLoop = nioEventLoop;
        try {
            channelPipeline.initChannel(this);
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException("SocketChannel init exception", e);
        }
        try {
            this.invokePipeline(ChannelState.NEW_CHANNEL);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void register() throws ClosedChannelException {
        if (this.sslHandler != null) {
            this.sslHandler.getSslService().beginHandshake(this.handshakeCompletedListener);
        }
        this.nioEventLoop.getSelector().register(this.channel, 1, this);
    }

    public void doRead(byte[] bytes) {
        this.initiateClose = false;
        try {
            this.readToPipeline(bytes);
        }
        catch (Exception e) {
            logger.error(e);
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.status == 1) {
            logger.warn("Channel:{} is closed:", (Object)this.getChannelId());
            return;
        }
        if (this.channelFutureListener != null) {
            this.channelFutureListener.operationComplete(this);
        }
        try {
            this.channel.shutdownInput();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        try {
            this.channel.shutdownOutput();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            logger.error("close channel exception", e);
        }
        this.status = 1;
        try {
            this.invokePipeline(ChannelState.CHANNEL_CLOSED);
        }
        catch (Exception e) {
            logger.error("close channel exception", e);
        }
        if (this.defaultChannelPipeline != null) {
            this.defaultChannelPipeline.clean();
            this.defaultChannelPipeline = null;
        }
    }

    @Override
    public synchronized void close(boolean initiateClose) {
        this.initiateClose = initiateClose;
        this.close();
    }

    @Override
    public void writeAndFlush(Object obj) {
        try {
            this.reverseInvokePipeline(ChannelState.CHANNEL_WRITE, obj);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public void writeToChannel(Object obj) {
        try {
            byte[] bytes = (byte[])obj;
            this.nioEventLoop.getBufferWriter().writeAndFlush(this, bytes);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public java.nio.channels.SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public final InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("channel is closed");
        }
    }

    @Override
    public ChannelPipeline getChannelPipeline() {
        return this.channelPipeline;
    }

    @Override
    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    @Override
    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public NioEventLoop getNioEventLoop() {
        return this.nioEventLoop;
    }

    @Override
    public void setSslHandshakeCompletedListener(IHandshakeCompletedListener handshakeCompletedListener2) {
        this.handshakeCompletedListener = handshakeCompletedListener2;
    }
}

