/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel;

import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.ChannelState;
import com.gettyio.core.channel.config.BaseConfig;
import com.gettyio.core.channel.group.ChannelFutureListener;
import com.gettyio.core.handler.ssl.SslHandler;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.ChannelHandlerAdapter;
import com.gettyio.core.pipeline.ChannelPipeline;
import com.gettyio.core.pipeline.DefaultChannelPipeline;
import com.gettyio.core.pipeline.all.ChannelAllBoundHandlerAdapter;
import com.gettyio.core.pipeline.out.ChannelOutboundHandlerAdapter;
import com.gettyio.core.util.ConcurrentSafeMap;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import com.gettyio.core.util.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;

public abstract class SocketChannel {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(SocketChannel.class);
    protected static final byte CHANNEL_STATUS_CLOSED = 1;
    protected static final byte CHANNEL_STATUS_ENABLED = 3;
    protected boolean keepAlive = true;
    protected boolean initiateClose = false;
    protected boolean handShak = false;
    protected ChunkPool chunkPool;
    protected byte status = (byte)3;
    protected BaseConfig config;
    protected DefaultChannelPipeline defaultChannelPipeline;
    protected ChannelFutureListener channelFutureListener;
    private LinkedNonReadBlockQueue<Object> outList = new LinkedNonReadBlockQueue();
    protected ConcurrentSafeMap<String, Object> channelAttribute = new ConcurrentSafeMap();

    public final String getChannelId() {
        return "aioChannel-" + System.identityHashCode(this);
    }

    public final boolean isInvalid() {
        return this.status != 3;
    }

    public void starRead() {
    }

    public abstract void close();

    public abstract void close(boolean var1);

    public abstract void writeAndFlush(Object var1);

    public abstract void writeToChannel(Object var1);

    public abstract InetSocketAddress getLocalAddress() throws IOException;

    public InetSocketAddress getRemoteAddress() throws IOException {
        return null;
    }

    public void readToPipeline(Object obj) throws Exception {
        this.invokePipeline(ChannelState.CHANNEL_READ, obj);
    }

    protected void invokePipeline(ChannelState channelState) throws Exception {
        this.invokePipeline(channelState, null);
    }

    protected void invokePipeline(ChannelState channelState, Object obj) throws Exception {
        if (this.defaultChannelPipeline == null) {
            return;
        }
        ChannelHandlerAdapter channelHandlerAdapter = this.defaultChannelPipeline.inPipeFirst();
        if (channelHandlerAdapter == null) {
            return;
        }
        switch (channelState) {
            case NEW_CHANNEL: {
                channelHandlerAdapter.channelAdded(this);
                break;
            }
            case CHANNEL_READ: {
                channelHandlerAdapter.decode(this, obj, this.outList);
                break;
            }
            case CHANNEL_CLOSED: {
                channelHandlerAdapter.channelClosed(this);
                break;
            }
            case INPUT_SHUTDOWN: {
                channelHandlerAdapter.exceptionCaught(this, new RuntimeException("socket channel input shutdown exception"));
                break;
            }
            case INPUT_EXCEPTION: {
                channelHandlerAdapter.exceptionCaught(this, new RuntimeException("socket channel input exception"));
                break;
            }
            case OUTPUT_SHUTDOWN: {
                channelHandlerAdapter.exceptionCaught(this, new RuntimeException("socket channel output shutdown exception"));
                break;
            }
            case OUTPUT_EXCEPTION: {
                channelHandlerAdapter.exceptionCaught(this, new RuntimeException("socket channel output exception"));
                break;
            }
        }
    }

    protected void reverseInvokePipeline(ChannelState channelState, Object obj) throws Exception {
        ChannelHandlerAdapter channelHandlerAdapter = this.defaultChannelPipeline.outPipeFirst();
        if (channelHandlerAdapter instanceof ChannelOutboundHandlerAdapter) {
            channelHandlerAdapter.encode(this, obj);
            return;
        }
        if (channelHandlerAdapter instanceof ChannelAllBoundHandlerAdapter) {
            channelHandlerAdapter.encode(this, obj);
            return;
        }
        this.writeToChannel(obj);
    }

    public DefaultChannelPipeline getDefaultChannelPipeline() {
        return this.defaultChannelPipeline != null ? this.defaultChannelPipeline : (this.defaultChannelPipeline = new DefaultChannelPipeline(this));
    }

    public AsynchronousSocketChannel getAsynchronousSocketChannel() {
        return null;
    }

    public java.nio.channels.SocketChannel getSocketChannel() {
        return null;
    }

    public ChunkPool getChunkPool() {
        return this.chunkPool;
    }

    public ChannelPipeline getChannelPipeline() {
        return null;
    }

    public void setSslHandler(SslHandler sslHandler) {
    }

    public SslHandler getSslHandler() {
        return null;
    }

    public void setSslHandshakeCompletedListener(IHandshakeCompletedListener handshakeCompletedListener2) {
    }

    public BaseConfig getConfig() {
        return this.config;
    }

    public void setChannelFutureListener(ChannelFutureListener channelFutureListener) {
        this.channelFutureListener = channelFutureListener;
    }

    public ConcurrentSafeMap<String, Object> getChannelAttribute() {
        return this.channelAttribute;
    }

    public Object getChannelAttribute(String key) {
        if (StringUtil.isEmpty(key)) {
            return null;
        }
        return this.channelAttribute.get(key);
    }

    public void setChannelAttribute(String key, Object obj) {
        this.channelAttribute.put(key, obj);
    }

    public void removeChannelAttribute(String key) {
        if (StringUtil.isEmpty(key)) {
            return;
        }
        this.channelAttribute.remove(key);
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isInitiateClose() {
        return this.initiateClose;
    }

    public boolean isHandShak() {
        return this.handShak;
    }

    public void setHandShak(boolean handShak) {
        this.handShak = handShak;
    }
}

