/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.group;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.group.ChannelFutureListener;
import com.gettyio.core.channel.group.ChannelGroup;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultChannelGroup
extends AbstractSet<SocketChannel>
implements ChannelGroup {
    private final String name;
    private final ConcurrentMap<String, SocketChannel> serverChannels = new ConcurrentHashMap<String, SocketChannel>();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(SocketChannel socketChannel) {
            DefaultChannelGroup.this.remove(socketChannel);
        }
    };

    public DefaultChannelGroup() {
        this.name = "defaultChannelGroup";
    }

    public DefaultChannelGroup(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SocketChannel find(String id) {
        SocketChannel socketChannel = (SocketChannel)this.serverChannels.get(id);
        if (socketChannel != null) {
            return socketChannel;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.serverChannels.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof SocketChannel) {
            return this.serverChannels.containsValue(o);
        }
        return false;
    }

    @Override
    public boolean add(SocketChannel socketChannel) {
        boolean added;
        boolean bl = added = this.serverChannels.putIfAbsent(socketChannel.getChannelId(), socketChannel) == null;
        if (added) {
            socketChannel.setChannelFutureListener(this.remover);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        SocketChannel c = null;
        if (o instanceof String) {
            c = (SocketChannel)this.serverChannels.remove(o);
        } else if (o instanceof SocketChannel) {
            c = (SocketChannel)o;
            c = (SocketChannel)this.serverChannels.remove(c.getChannelId());
        }
        if (c == null) {
            return false;
        }
        c.setChannelFutureListener(null);
        return true;
    }

    @Override
    public void clear() {
        this.serverChannels.clear();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        return channels.toArray(a);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int compareTo(ChannelGroup o) {
        int v = this.name().compareTo(o.name());
        if (v != 0) {
            return v;
        }
        return System.identityHashCode(this) - System.identityHashCode(o);
    }

    @Override
    public Iterator<SocketChannel> iterator() {
        return this.serverChannels.values().iterator();
    }

    @Override
    public int size() {
        return this.serverChannels.size();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(name: " + this.name() + ", size: " + this.size() + ')';
    }
}

