/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.starter;

import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.AioChannel;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.config.ServerConfig;
import com.gettyio.core.channel.internal.ReadCompletionHandler;
import com.gettyio.core.channel.internal.WriteCompletionHandler;
import com.gettyio.core.channel.starter.AioStarter;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.ChannelPipeline;
import com.gettyio.core.util.DateTimeUtil;
import com.gettyio.core.util.ThreadPool;
import com.gettyio.core.util.Time;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AioServerStarter
extends AioStarter {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AioServerStarter.class);
    protected ServerConfig config = new ServerConfig();
    protected ReadCompletionHandler readCompletionHandler;
    protected WriteCompletionHandler writeCompletionHandler;
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private volatile boolean running = true;

    public AioServerStarter(int port) {
        this.config.setPort(port);
    }

    public AioServerStarter(String host, int port) {
        this.config.setHost(host);
        this.config.setPort(port);
    }

    public AioServerStarter(ServerConfig config) {
        if (config == null) {
            throw new NullPointerException("AioServerConfig can't null");
        }
        if (config.getPort() == 0) {
            throw new NullPointerException("AioServerConfig port can't null");
        }
        this.config = config;
    }

    public AioServerStarter channelInitializer(ChannelPipeline channelPipeline) {
        this.channelPipeline = channelPipeline;
        return this;
    }

    public AioServerStarter bossThreadNum(int threadNum) {
        if (threadNum >= 3) {
            this.bossThreadNum = threadNum;
        }
        return this;
    }

    public AioServerStarter workerThreadNum(int threadNum) {
        if (threadNum >= 3) {
            this.workerThreadNum = threadNum;
        }
        return this;
    }

    public void start() throws Exception {
        LOGGER.info("\r\n                       tt     yt             \n                       tt     ye             \n  ttttt      tttt     teet   ytety   tt   ty \n tetytgt    yey tt     et     tey    tey yet \nytt  yet    et   ey    tt     ye     yet tey \nyet  yet    getttty    tt     ye      ttyet  \nytt  ygt    et         tt     ye      yetey  \n tetytgt    yetytt     teyy   yeyy     tgt   \n     tet     tttty     ytty    tty     tey   \nytt  yey                               te    \n ttttty                              yttt    \n   yy                                yyy     \n\r\n  getty version:(1.4.9)");
        if (this.channelPipeline == null) {
            throw new RuntimeException("ChannelPipeline can't be null");
        }
        if (this.chunkPool == null) {
            this.chunkPool = new ChunkPool(this.config.getServerChunkSize().intValue(), new Time(), this.config.isDirect());
        }
        this.bossThreadPool = new ThreadPool(0, this.bossThreadNum);
        this.workerThreadPool = new ThreadPool(0, this.workerThreadNum);
        this.startTcpAsyn();
    }

    private final void startTcp() throws IOException {
        try {
            this.readCompletionHandler = new ReadCompletionHandler(this.workerThreadPool);
            this.writeCompletionHandler = new WriteCompletionHandler();
            this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(this.bossThreadNum, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable target) {
                    return new Thread(target);
                }
            });
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.asynchronousChannelGroup);
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 1000);
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), 1000);
            }
            this.bossThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    while (AioServerStarter.this.running) {
                        Future<AsynchronousSocketChannel> future = AioServerStarter.this.serverSocketChannel.accept();
                        try {
                            final AsynchronousSocketChannel channel = future.get();
                            AioServerStarter.this.bossThreadPool.execute(new Runnable(){

                                @Override
                                public void run() {
                                    AioServerStarter.this.createTcpChannel(channel);
                                }
                            });
                        }
                        catch (Exception e) {
                            LOGGER.error("AsynchronousSocketChannel accept Exception", e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        LOGGER.info("getty server started TCP on port {},bossThreadNum:{} ,workerThreadNum:{}", this.config.getPort(), this.bossThreadNum, this.workerThreadNum);
        LOGGER.info("getty server config is {}", (Object)this.config.toString());
    }

    private final void startTcpAsyn() throws IOException {
        try {
            this.readCompletionHandler = new ReadCompletionHandler(this.workerThreadPool);
            this.writeCompletionHandler = new WriteCompletionHandler();
            this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(this.bossThreadNum, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable target) {
                    return new Thread(target);
                }
            });
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.asynchronousChannelGroup);
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 1000);
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), 1000);
            }
            this.bossThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    AioServerStarter.this.serverSocketChannel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Object>(){

                        @Override
                        public void completed(AsynchronousSocketChannel result, Object attachment) {
                            AioServerStarter.this.createTcpChannel(result);
                            AioServerStarter.this.serverSocketChannel.accept(null, this);
                        }

                        @Override
                        public void failed(Throwable exc, Object attachment) {
                            if (AioServerStarter.this.serverSocketChannel != null) {
                                LOGGER.error("accept failed at time:" + DateTimeUtil.getCurrentTime(), exc);
                                AioServerStarter.this.serverSocketChannel.accept(null, this);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        LOGGER.info("getty server started TCP on port {},bossThreadNum:{} ,workerThreadNum:{}", this.config.getPort(), this.bossThreadNum, this.workerThreadNum);
        LOGGER.info("getty server config is {}", (Object)this.config.toString());
    }

    private void createTcpChannel(AsynchronousSocketChannel channel) {
        block2: {
            AioChannel aioChannel = null;
            try {
                aioChannel = new AioChannel(channel, this.config, this.readCompletionHandler, this.writeCompletionHandler, this.chunkPool, this.channelPipeline);
                ((SocketChannel)aioChannel).starRead();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                if (aioChannel == null) break block2;
                this.closeChannel(channel);
            }
        }
    }

    private void closeChannel(AsynchronousSocketChannel channel) {
        try {
            channel.shutdownInput();
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            channel.shutdownOutput();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void shutdown() {
        this.running = false;
        if (this.serverSocketChannel != null) {
            try {
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                LOGGER.error(" serverSocketChannel.close()", e);
            }
            this.serverSocketChannel = null;
        }
        if (!this.bossThreadPool.isShutDown()) {
            this.bossThreadPool.shutdownNow();
        }
        if (!this.workerThreadPool.isShutDown()) {
            this.workerThreadPool.shutdownNow();
        }
        if (!this.asynchronousChannelGroup.isShutdown()) {
            try {
                this.asynchronousChannelGroup.shutdownNow();
            }
            catch (IOException e) {
                LOGGER.error("asynchronousChannelGroup.shutdownNow()", e);
            }
        }
        try {
            boolean b = this.asynchronousChannelGroup.awaitTermination(5L, TimeUnit.SECONDS);
            if (b) {
                LOGGER.info("asynchronousChannelGroup shutdown success at " + new Date());
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("asynchronousChannelGroup.awaitTermination()", e);
        }
        LOGGER.info("server shutdown at " + new Date());
    }
}

