/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.starter;

import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.NioChannel;
import com.gettyio.core.channel.SocketMode;
import com.gettyio.core.channel.UdpChannel;
import com.gettyio.core.channel.config.ServerConfig;
import com.gettyio.core.channel.loop.NioEventLoop;
import com.gettyio.core.channel.starter.NioStarter;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.ChannelPipeline;
import com.gettyio.core.util.FastArrayList;
import com.gettyio.core.util.ThreadPool;
import com.gettyio.core.util.Time;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class NioServerStarter
extends NioStarter {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(NioServerStarter.class);
    protected ServerConfig serverConfig = new ServerConfig();
    private volatile boolean running = true;
    private ServerSocketChannel serverSocketChannel;
    private DatagramChannel datagramChannel;
    private Selector selector;
    private FastArrayList<NioEventLoop> nioEventLoopFastArrayList = new FastArrayList<NioEventLoop>(NioEventLoop.class);

    public NioServerStarter(int port) {
        this.serverConfig.setPort(port);
    }

    public NioServerStarter(String host, int port) {
        this.serverConfig.setHost(host);
        this.serverConfig.setPort(port);
    }

    public NioServerStarter(ServerConfig config) {
        if (config == null) {
            throw new NullPointerException("serverConfig can't null");
        }
        if (config.getPort() == 0) {
            throw new NullPointerException("serverConfig port can't null");
        }
        this.serverConfig = config;
    }

    public NioServerStarter channelInitializer(ChannelPipeline channelPipeline) {
        this.channelPipeline = channelPipeline;
        return this;
    }

    public NioServerStarter bossThreadNum(int threadNum) {
        if (threadNum >= 3) {
            this.bossThreadNum = threadNum;
        }
        return this;
    }

    public NioServerStarter workerThreadNum(int threadNum) {
        if (threadNum >= 3) {
            this.workerThreadNum = threadNum;
        }
        return this;
    }

    public NioServerStarter socketMode(SocketMode socketMode) {
        this.socketMode = socketMode;
        return this;
    }

    public void start() throws Exception {
        LOGGER.info("\r\n                       tt     yt             \n                       tt     ye             \n  ttttt      tttt     teet   ytety   tt   ty \n tetytgt    yey tt     et     tey    tey yet \nytt  yet    et   ey    tt     ye     yet tey \nyet  yet    getttty    tt     ye      ttyet  \nytt  ygt    et         tt     ye      yetey  \n tetytgt    yetytt     teyy   yeyy     tgt   \n     tet     tttty     ytty    tty     tey   \nytt  yey                               te    \n ttttty                              yttt    \n   yy                                yyy     \n\r\n  getty version:(1.4.9)");
        if (this.channelPipeline == null) {
            throw new RuntimeException("ChannelPipeline can't be null");
        }
        if (this.chunkPool == null) {
            this.chunkPool = new ChunkPool(this.serverConfig.getServerChunkSize().intValue(), new Time(), this.serverConfig.isDirect());
        }
        this.bossThreadPool = new ThreadPool(0, this.bossThreadNum);
        for (int i = 0; i < this.workerThreadNum; ++i) {
            NioEventLoop nioEventLoop = new NioEventLoop(this.serverConfig, this.chunkPool);
            nioEventLoop.run();
            this.nioEventLoopFastArrayList.add(nioEventLoop);
        }
        if (this.socketMode == SocketMode.TCP) {
            this.startTcp();
        } else {
            this.startUdp();
        }
    }

    private final void startTcp() throws IOException {
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        if (this.serverConfig.getHost() != null) {
            this.serverSocketChannel.bind(new InetSocketAddress(this.serverConfig.getHost(), this.serverConfig.getPort()), 1000);
        } else {
            this.serverSocketChannel.bind(new InetSocketAddress(this.serverConfig.getPort()), 1000);
        }
        this.selector = Selector.open();
        this.serverSocketChannel.register(this.selector, 16);
        this.bossThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                while (NioServerStarter.this.running) {
                    try {
                        int readyChannels = NioServerStarter.this.selector.select();
                        if (readyChannels <= 0) continue;
                        Iterator<SelectionKey> iterator = NioServerStarter.this.selector.selectedKeys().iterator();
                        while (iterator.hasNext()) {
                            SelectionKey key = iterator.next();
                            if (key.isAcceptable()) {
                                SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
                                socketChannel.configureBlocking(false);
                                NioServerStarter.this.createTcpChannel(socketChannel);
                            }
                            iterator.remove();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("socketChannel accept Exception", e);
                    }
                }
            }
        });
    }

    private final void startUdp() throws IOException {
        this.datagramChannel = DatagramChannel.open();
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.bind(new InetSocketAddress(this.serverConfig.getPort()));
        if (this.serverConfig.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.serverConfig.getSocketOptions().entrySet()) {
                this.datagramChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        this.selector = Selector.open();
        this.datagramChannel.register(this.selector, 1);
        this.createUdpChannel(this.datagramChannel, this.selector);
        LOGGER.info("getty server started UDP on port {},bossThreadNum:{} ,workerThreadNum:{}", this.serverConfig.getPort(), this.bossThreadNum, this.workerThreadNum);
        LOGGER.info("getty server config is {}", (Object)this.serverConfig.toString());
    }

    private void createTcpChannel(SocketChannel channel) {
        block2: {
            NioChannel socketChannel = null;
            try {
                NioEventLoop nioEventLoop = this.nioEventLoopFastArrayList.round();
                socketChannel = new NioChannel(this.serverConfig, channel, nioEventLoop, this.channelPipeline);
                socketChannel.register();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                if (socketChannel == null) break block2;
                this.closeChannel(channel);
            }
        }
    }

    private void createUdpChannel(DatagramChannel datagramChannel, Selector selector) {
        UdpChannel udpChannel = new UdpChannel(datagramChannel, selector, this.serverConfig, this.chunkPool, this.channelPipeline, this.workerThreadNum);
        udpChannel.starRead();
    }

    private void closeChannel(SocketChannel channel) {
        try {
            channel.shutdownInput();
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            channel.shutdownOutput();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public final void shutdown() {
        this.running = false;
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        if (this.datagramChannel != null) {
            try {
                this.datagramChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.datagramChannel = null;
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.selector = null;
        }
        for (NioEventLoop nioEventLoop : this.nioEventLoopFastArrayList) {
            nioEventLoop.shutdown();
        }
        LOGGER.info("getty server is shutdown in " + new Date());
    }
}

