/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentSafeMap<K, V> {
    private final Map<K, V> map;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock r = this.lock.readLock();
    private final Lock w = this.lock.writeLock();

    public ConcurrentSafeMap() {
        this.map = new HashMap();
    }

    public ConcurrentSafeMap(Map<K, V> map) {
        this.map = map;
    }

    public V get(Object key) {
        this.r.lock();
        try {
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        this.w.lock();
        try {
            V v = this.map.put(key, value);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    public V remove(Object key) {
        this.w.lock();
        try {
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.w.lock();
        try {
            this.map.putAll(m);
        }
        finally {
            this.w.unlock();
        }
    }

    public void clear() {
        this.w.lock();
        try {
            this.map.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    public int size() {
        this.r.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isEmpty() {
        this.r.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean containsValue(Object value) {
        this.r.lock();
        try {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public V putIfAbsent(K key, V value) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        this.put(key, value);
        return null;
    }

    public Collection<V> values() {
        return this.map.values();
    }
}

