/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;

public class FastArrayList<T>
implements Iterable<T> {
    private int currentIndex = 0;
    private transient T[] data = null;
    private int size = 0;
    private static final int DEFAULT_CAPACITY = 10;

    public FastArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u96c6\u5408\u521d\u59cb\u5bb9\u91cf\u503c Illegal Capacity: " + initialCapacity);
        }
        this.data = new Object[initialCapacity];
    }

    public FastArrayList(Class<T> type, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u96c6\u5408\u521d\u59cb\u5bb9\u91cf\u503c Illegal Capacity: " + initialCapacity);
        }
        this.data = (Object[])Array.newInstance(type, initialCapacity);
    }

    public FastArrayList() {
        this(10);
    }

    public FastArrayList(Class<T> type) {
        this(type, 10);
    }

    public void checkIncrease(int index, T obj) {
        if (this.size >= this.data.length) {
            Object[] newData = new Object[this.size * 2];
            if (index == -1 && obj == null) {
                System.arraycopy(this.data, 0, newData, 0, this.size);
            } else {
                System.arraycopy(this.data, 0, newData, 0, this.size);
                System.arraycopy(this.data, index, newData, index + 1, this.size - index);
                newData[index] = obj;
            }
            this.data = newData;
        }
    }

    public int size() {
        return this.size;
    }

    public int indexOf(T o) {
        if (o == null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (!o.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean add(T obj) {
        this.checkIncrease(-1, null);
        this.data[this.size++] = obj;
        return true;
    }

    public boolean addFirst(T obj) {
        return this.add(0, obj);
    }

    public boolean addLast(T obj) {
        return this.add(this.size, obj);
    }

    public boolean add(int index, T obj) {
        if (index == this.size) {
            this.add(obj);
        } else if (this.checkIndexOut(index)) {
            if (this.size < this.data.length) {
                System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
                this.data[index] = obj;
            } else {
                this.checkIncrease(index, obj);
            }
            ++this.size;
        }
        return true;
    }

    public boolean checkIndexOut(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("\u6307\u5b9a\u7684\u7d22\u5f15\u8d8a\u754c\uff0c\u96c6\u5408\u5927\u5c0f\u4e3a:" + this.size + ",\u60a8\u6307\u5b9a\u7684\u7d22\u5f15\u5927\u5c0f\u4e3a:" + index);
        }
        return true;
    }

    public T get(int index) {
        this.checkIndexOut(index);
        return this.data[index];
    }

    public T getFirst() {
        return this.get(0);
    }

    public T getLast() {
        return this.get(this.size - 1);
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
    }

    public T remove(int index) {
        if (index == this.size + 1) {
            throw new IndexOutOfBoundsException("\u6307\u5b9a\u7684\u7d22\u5f15\u8d8a\u754c\uff0c\u96c6\u5408\u5927\u5c0f\u4e3a:" + this.size + ",\u60a8\u6307\u5b9a\u7684\u7d22\u5f15\u5927\u5c0f\u4e3a:" + index);
        }
        if (this.checkIndexOut(index)) {
            T obj = this.data[index];
            if (index == this.size) {
                this.data[index] = null;
            } else {
                System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
            }
            --this.size;
            return obj;
        }
        return null;
    }

    public boolean remove(T obj) {
        for (int i = 0; i < this.size; ++i) {
            if (!obj.equals(this.data[i])) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public T change(int index, T obj) {
        this.checkIndexOut(index);
        T oldObj = this.data[index];
        this.data[index] = obj;
        return oldObj;
    }

    public boolean contain(T obj) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!obj.equals(this.data[i])) continue;
            return true;
        }
        return false;
    }

    public T[] arrays() {
        return this.data;
    }

    public T[] toArray() {
        T[] elements = this.arrays();
        return Arrays.copyOf(elements, elements.length);
    }

    public T round() {
        this.currentIndex = (this.currentIndex + 1) % this.size;
        return this.get(this.currentIndex);
    }

    @Override
    public Iterator<T> iterator() {
        class Iter
        implements Iterator<T> {
            Iter() {
            }

            @Override
            public boolean hasNext() {
                return FastArrayList.this.currentIndex < FastArrayList.this.size;
            }

            @Override
            public T next() {
                return FastArrayList.this.data[FastArrayList.this.currentIndex++];
            }

            @Override
            public void remove() {
            }
        }
        return new Iter();
    }
}

