/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.http;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.expansion.handler.codec.http.HttpConstants;
import com.gettyio.expansion.handler.codec.http.HttpMessage;
import com.gettyio.expansion.handler.codec.http.HttpRequest;
import com.gettyio.expansion.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.util.Map;

public class HttpEncodeSerializer {
    public static void encodeInitialLine(AutoByteBuffer buffer, HttpRequest request) throws IOException {
        byte[] bytes = request.getHttpMethod().toString().getBytes();
        buffer.writeBytes(bytes);
        buffer.writeByte((byte)32);
        buffer.writeBytes(request.getRequestUri().getBytes());
        buffer.writeByte((byte)32);
        buffer.writeBytes(request.getHttpVersion().toString().getBytes());
        buffer.writeBytes(HttpConstants.CRLF);
    }

    public static void encodeInitialLine(AutoByteBuffer buffer, HttpResponse response) throws IOException {
        byte[] bytes = response.getHttpVersion().toString().getBytes();
        buffer.writeBytes(bytes);
        buffer.writeByte((byte)32);
        buffer.writeBytes(response.getHttpResponseStatus().getBytes());
        buffer.writeBytes(HttpConstants.CRLF);
    }

    public static void encodeHeaders(AutoByteBuffer buffer, HttpMessage message) throws IOException {
        for (Map.Entry<String, String> header : message.getHeaders()) {
            byte[] key = header.getKey().getBytes();
            byte[] value = header.getValue().getBytes();
            buffer.writeBytes(key);
            buffer.writeBytes(HttpConstants.COLON_SP);
            buffer.writeBytes(value);
            buffer.writeBytes(HttpConstants.CRLF);
        }
        buffer.writeBytes(HttpConstants.CRLF);
    }

    public static void encodeContent(AutoByteBuffer buffer, HttpRequest request) throws IOException {
        if (request.getHttpBody().getContent() != null) {
            buffer.writeBytes(request.getHttpBody().getContent());
            buffer.writeBytes(HttpConstants.CRLF);
        }
    }

    public static void encodeContent(AutoByteBuffer buffer, HttpResponse response) throws IOException {
        if (response.getHttpBody().getContent() != null) {
            buffer.writeBytes(response.getHttpBody().getContent());
            buffer.writeBytes(HttpConstants.CRLF);
        }
    }
}

