/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.http;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.ObjectToMessageDecoder;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import com.gettyio.expansion.handler.codec.http.HttpDecodeSerializer;
import com.gettyio.expansion.handler.codec.http.HttpRequest;

public class HttpRequestDecoder
extends ObjectToMessageDecoder {
    protected static final InternalLogger log = InternalLoggerFactory.getInstance(HttpRequestDecoder.class);
    AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer();
    HttpRequest httpRequest;

    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        this.autoByteBuffer.writeBytes((byte[])obj);
        if (this.httpRequest == null) {
            this.httpRequest = new HttpRequest();
            this.httpRequest.setReadStatus(1);
        }
        if (this.httpRequest.getReadStatus() == 1) {
            if (!HttpDecodeSerializer.readRequestLine(this.autoByteBuffer, this.httpRequest)) {
                return;
            }
            this.httpRequest.setReadStatus(2);
        }
        if (this.httpRequest.getReadStatus() == 2) {
            if (!HttpDecodeSerializer.readHeaders(this.autoByteBuffer, this.httpRequest)) {
                return;
            }
            this.httpRequest.setReadStatus(3);
        }
        if (this.httpRequest.getReadStatus() == 3 && !HttpDecodeSerializer.readContent(this.autoByteBuffer, this.httpRequest)) {
            return;
        }
        super.decode(socketChannel, (Object)this.httpRequest, out);
        this.autoByteBuffer.clear();
        this.httpRequest = null;
    }
}

