/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.mqtt;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.handler.codec.DecoderResult;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnAckMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnAckVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnectMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnectPayload;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnectVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttFixedHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttMessageIdVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttPubAckMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttPublishMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttPublishVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubAckMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubAckPayload;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubscribeMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubscribePayload;
import com.gettyio.expansion.handler.codec.mqtt.MqttUnsubAckMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttUnsubscribeMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttUnsubscribePayload;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (AutoByteBuffer)payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                return new MqttMessage(mqttFixedHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure((Throwable)cause));
    }

    public static MqttMessage newInvalidMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Throwable cause) {
        return new MqttMessage(mqttFixedHeader, variableHeader, null, DecoderResult.failure((Throwable)cause));
    }

    private MqttMessageFactory() {
    }
}

