/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.protobuf;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.MessageToByteEncoder;

public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder {
    public void encode(SocketChannel socketChannel, Object obj) throws Exception {
        byte[] bytes = (byte[])obj;
        int bodyLen = bytes.length;
        int headerLen = ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size(bodyLen);
        byte[] b = new byte[headerLen + bodyLen];
        AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer((int)bodyLen);
        ProtobufVarint32LengthFieldPrepender.writeRawVarint32(autoByteBuffer, bodyLen);
        autoByteBuffer.writeBytes(bytes);
        try {
            autoByteBuffer.readBytes(b);
        }
        catch (AutoByteBuffer.ByteBufferException e) {
            e.printStackTrace();
        }
        super.encode(socketChannel, (Object)b);
    }

    static void writeRawVarint32(AutoByteBuffer out, int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                out.write(value);
                return;
            }
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }
}

