/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.websocket;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.DecoderException;
import com.gettyio.core.handler.codec.ObjectToMessageDecoder;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.CharsetUtil;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import com.gettyio.expansion.handler.codec.websocket.Opcode;
import com.gettyio.expansion.handler.codec.websocket.WebSocketHandShak;
import com.gettyio.expansion.handler.codec.websocket.WebSocketRequest;
import com.gettyio.expansion.handler.codec.websocket.frame.BinaryWebSocketFrame;
import com.gettyio.expansion.handler.codec.websocket.frame.CloseWebSocketFrame;
import com.gettyio.expansion.handler.codec.websocket.frame.ContinuationWebSocketFrame;
import com.gettyio.expansion.handler.codec.websocket.frame.PingWebSocketFrame;
import com.gettyio.expansion.handler.codec.websocket.frame.PongWebSocketFrame;
import com.gettyio.expansion.handler.codec.websocket.frame.TextWebSocketFrame;
import com.gettyio.expansion.handler.codec.websocket.frame.WebSocketFrame;

public class WebSocketDecoder
extends ObjectToMessageDecoder {
    protected static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(WebSocketDecoder.class);
    public static String protocolVersion = String.valueOf(0);
    WebSocketFrame messageFrame;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        if (socketChannel.isHandShak()) {
            if (Integer.valueOf(protocolVersion) >= 6) {
                AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer().writeBytes((byte[])obj);
                WebSocketFrame frame = this.parserVersion6(autoByteBuffer);
                this.messageFrame = null;
                if (frame == null) throw new DecoderException("frame is null , close the connection");
                out.put((Object)frame);
                super.decode(socketChannel, obj, out);
                return;
            } else {
                out.put(obj);
                super.decode(socketChannel, obj, out);
            }
            return;
        } else {
            String msg = new String((byte[])obj, CharsetUtil.UTF_8);
            WebSocketRequest requestInfo = WebSocketHandShak.parserRequest(msg);
            byte[] bytes = WebSocketHandShak.generateHandshake(requestInfo, socketChannel).getBytes();
            if (socketChannel.getSslHandler() == null) {
                socketChannel.writeToChannel((Object)bytes);
            } else {
                socketChannel.getSslHandler().encode(socketChannel, (Object)bytes);
            }
            protocolVersion = requestInfo.getSecVersion().toString();
            socketChannel.setHandShak(true);
        }
    }

    private WebSocketFrame parserVersion6(AutoByteBuffer buffer) throws Exception {
        do {
            int bufferDataLength;
            if (this.messageFrame == null) {
                byte bt = buffer.read(0);
                byte opcode = (byte)(bt & 0xF);
                if (null == Opcode.valueOf(opcode)) {
                    return null;
                }
                switch (Opcode.valueOf(opcode)) {
                    case CONTINUATION: {
                        this.messageFrame = new ContinuationWebSocketFrame();
                        break;
                    }
                    case TEXT: {
                        this.messageFrame = new TextWebSocketFrame();
                        break;
                    }
                    case BINARY: {
                        this.messageFrame = new BinaryWebSocketFrame();
                        break;
                    }
                    case CLOSE: {
                        this.messageFrame = new CloseWebSocketFrame();
                        break;
                    }
                    case PING: {
                        this.messageFrame = new PingWebSocketFrame();
                        break;
                    }
                    case PONG: {
                        this.messageFrame = new PongWebSocketFrame();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (!this.messageFrame.isReadFinish()) {
                this.messageFrame.parseMessageHeader(buffer);
            }
            int dataLength = (long)(bufferDataLength = buffer.readableBytes()) > this.messageFrame.getDateLength() ? new Long(this.messageFrame.getDateLength()).intValue() : bufferDataLength;
            byte[] bytes = new byte[dataLength];
            if (dataLength > 0) {
                buffer.readBytes(bytes);
                if (this.messageFrame.isMask()) {
                    for (int i = 0; i < dataLength; ++i) {
                        int n = i;
                        bytes[n] = (byte)(bytes[n] ^ this.messageFrame.getMaskingKey()[i % 4]);
                    }
                }
                this.messageFrame.setPayloadData(bytes);
            }
            if (!this.messageFrame.isReadFinish()) continue;
            return this.messageFrame;
        } while (buffer.hasRemaining());
        return null;
    }

    public void channelClosed(SocketChannel socketChannel) throws Exception {
        socketChannel.setHandShak(false);
        protocolVersion = "0";
        this.messageFrame = null;
        super.channelClosed(socketChannel);
    }
}

