/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.websocket;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.Base64;
import com.gettyio.core.util.fastmd5.util.MD5;
import com.gettyio.expansion.handler.codec.websocket.WebSocketRequest;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class WebSocketHandShak {
    protected static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(SocketChannel.class);

    public static WebSocketRequest parserRequest(String requestData) {
        WebSocketRequest requestInfo = new WebSocketRequest();
        String[] requestDatas = requestData.split("\r\n");
        if (requestDatas.length < 0) {
            return null;
        }
        String line = requestDatas[0];
        String[] requestLine = line.split(" ");
        if (requestLine.length < 2) {
            LOGGER.info("Wrong Request-Line format: " + line);
            return null;
        }
        requestInfo.setRequestUri(requestLine[1]);
        for (int i = 1; i < requestDatas.length; ++i) {
            line = requestDatas[i];
            if (line.equalsIgnoreCase("") && i + 1 < requestDatas.length) {
                line = requestDatas[i + 1] + "00000000";
                byte[] token = line.getBytes();
                requestInfo.setDigest(WebSocketHandShak.makeResponseToken(requestInfo, token));
                break;
            }
            String[] parts = line.split(": ", 2);
            if (parts.length != 2) {
                LOGGER.info("Wrong field format: " + line);
                return null;
            }
            String name = parts[0].toLowerCase();
            String value = parts[1].toLowerCase();
            if ("upgrade".equals(name)) {
                if (!"websocket".equals(value)) {
                    LOGGER.info("Wrong value of upgrade field: " + line);
                    return null;
                }
                requestInfo.setUpgrade(true);
                continue;
            }
            if ("connection".equals(name)) {
                if (!"upgrade".equals(value)) {
                    LOGGER.info("Wrong value of connection field: " + line);
                }
                requestInfo.setConnection(true);
                continue;
            }
            if ("host".equals(name)) {
                requestInfo.setHost(value);
                continue;
            }
            if ("origin".equals(name)) {
                requestInfo.setOrigin(value);
                continue;
            }
            if ("sec-websocket-key1".equals(name) || "sec-websocket-key2".equals(name)) {
                LOGGER.info(name + ":" + value);
                Integer spaces = new Integer(0);
                Long number = new Long(0L);
                char[] cArray = parts[1].toCharArray();
                int n = cArray.length;
                for (int j = 0; j < n; ++j) {
                    Character c = Character.valueOf(cArray[j]);
                    if (c.equals(Character.valueOf(' '))) {
                        spaces = spaces + 1;
                    }
                    if (!Character.isDigit(c.charValue())) continue;
                    number = number * 10L;
                    number = number + (long)Character.digit(c.charValue(), 10);
                }
                number = number / (long)spaces.intValue();
                if ("key1".endsWith(name)) {
                    requestInfo.setKey1(number);
                    continue;
                }
                requestInfo.setKey2(number);
                continue;
            }
            if ("cookie".equals(name)) {
                requestInfo.setCookie(value);
                continue;
            }
            if ("sec-websocket-key".equals(name)) {
                requestInfo.setDigest(WebSocketHandShak.getKey(parts[1]));
                continue;
            }
            if ("sec-websocket-version".equals(name)) {
                requestInfo.setSecVersion(Integer.valueOf(value));
                continue;
            }
            if ("sec-websocket-extensions".equals(name)) {
                LOGGER.info(value);
                continue;
            }
            LOGGER.info("Unexpected header field: " + line);
        }
        return requestInfo;
    }

    protected static String makeResponseToken(WebSocketRequest requestInfo, byte[] token) {
        MD5 md5 = new MD5();
        Integer i = 0;
        while (i < 2) {
            byte[] asByte = new byte[4];
            long key = i == 0 ? (long)requestInfo.getKey1().intValue() : (long)requestInfo.getKey2().intValue();
            asByte[0] = (byte)(key >> 24);
            asByte[1] = (byte)(key << 8 >> 24);
            asByte[2] = (byte)(key << 16 >> 24);
            asByte[3] = (byte)(key << 24 >> 24);
            md5.Update(asByte);
            i = i + 1;
        }
        md5.Update(token);
        return md5.asHex();
    }

    public static String getKey(String key) {
        String guid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        key = key + guid;
        LOGGER.info(key);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(key.getBytes("iso-8859-1"), 0, key.length());
            byte[] sha1Hash = md.digest();
            key = WebSocketHandShak.base64Encode(sha1Hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return key;
    }

    public static String base64Encode(byte[] input) {
        String base64 = Base64.encodeBytes((byte[])input);
        return base64;
    }

    public static String generateHandshake(WebSocketRequest requestInfo, SocketChannel aioChannel) {
        StringBuilder sb = new StringBuilder();
        if (requestInfo.getSecVersion() < 4) {
            sb.append("HTTP/1.1 101 WebSocket Protocol Handshake").append("\r\n").append("Upgrade: WebSocket").append("\r\n").append("Connection: Upgrade").append("\r\n").append("Sec-WebSocket-Origin: ").append(requestInfo.getOrigin()).append("\r\n");
            if (aioChannel.getSslHandler() == null) {
                sb.append("Sec-WebSocket-Location: ws://").append(requestInfo.getHost()).append(requestInfo.getRequestUri()).append("\r\n");
            } else {
                sb.append("Sec-WebSocket-Location: wss://").append(requestInfo.getHost()).append(requestInfo.getRequestUri()).append("\r\n");
            }
            if (requestInfo.getCookie() != null) {
                sb.append("cookie: ").append(requestInfo.getCookie()).append("\r\n");
            }
            sb.append("\r\n");
            sb.append(requestInfo.getDigest());
        } else {
            sb.append("HTTP/1.1 101 Switching Protocols").append("\r\n").append("Upgrade: websocket").append("\r\n").append("Connection: Upgrade").append("\r\n").append("Sec-WebSocket-Accept: ").append(requestInfo.getDigest()).append("\r\n").append("Sec-WebSocket-Origin: ").append(requestInfo.getOrigin()).append("\r\n");
            if (aioChannel.getSslHandler() == null) {
                sb.append("Sec-WebSocket-Location: ws://").append(requestInfo.getHost()).append(requestInfo.getRequestUri()).append("\r\n");
            } else {
                sb.append("Sec-WebSocket-Location: wss://").append(requestInfo.getHost()).append(requestInfo.getRequestUri()).append("\r\n");
            }
            sb.append("\r\n");
        }
        LOGGER.info("the response: " + sb.toString());
        return sb.toString();
    }
}

