/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.ipfilter;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.expansion.handler.ipfilter.AbstractRemoteAddressFilter;
import com.gettyio.expansion.handler.ipfilter.IpFilterRule;
import com.gettyio.expansion.handler.ipfilter.IpFilterRuleType;
import com.gettyio.expansion.handler.ipfilter.IpRange;
import com.gettyio.expansion.handler.ipfilter.RuleBasedIpFilter;
import java.net.InetSocketAddress;
import java.util.List;

public class IpFilterRuleHandler
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    IpFilterRule rules;

    public IpFilterRuleHandler(List<IpRange> ips, IpFilterRuleType ipFilterRuleType) {
        if (ips == null) {
            throw new NullPointerException("rules");
        }
        this.rules = new RuleBasedIpFilter(ips, ipFilterRuleType);
    }

    @Override
    protected boolean accept(SocketChannel socketChannel, InetSocketAddress remoteAddress) {
        if (this.rules.matches(remoteAddress)) {
            return this.rules.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

