/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.ipfilter;

import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.NetWorkUtil;
import com.gettyio.expansion.handler.ipfilter.IpFilterRule;
import com.gettyio.expansion.handler.ipfilter.IpFilterRuleType;
import com.gettyio.expansion.handler.ipfilter.IpRange;
import java.net.InetSocketAddress;
import java.util.List;

public class RuleBasedIpFilter
implements IpFilterRule {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RuleBasedIpFilter.class);
    List<IpRange> ips;
    IpFilterRuleType ipFilterRuleType;

    public RuleBasedIpFilter(List<IpRange> ips, IpFilterRuleType ipFilterRuleType) {
        if (ips == null) {
            logger.warn("blackIps was null");
        }
        this.ips = ips;
        this.ipFilterRuleType = ipFilterRuleType;
    }

    @Override
    public boolean matches(InetSocketAddress remoteAddress) {
        if (this.ips == null) {
            return true;
        }
        String ip = remoteAddress.getHostString();
        long ipLong = NetWorkUtil.ipToLong((String)ip);
        for (IpRange ipRange : this.ips) {
            long ipStart = NetWorkUtil.ipToLong((String)ipRange.getIpStart());
            long ipEnd = NetWorkUtil.ipToLong((String)ipRange.getIpEnd());
            if (ipLong < ipStart || ipLong > ipEnd) continue;
            return true;
        }
        return false;
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.ipFilterRuleType;
    }
}

