/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.timeout;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.constant.IdleState;
import com.gettyio.core.pipeline.all.ChannelAllBoundHandlerAdapter;
import com.gettyio.core.util.ThreadPool;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelAllBoundHandlerAdapter {
    boolean readerIdle = false;
    boolean writerIdle = false;
    ThreadPool pool = new ThreadPool(0, 3);

    public IdleStateHandler(SocketChannel socketChannel, int readerIdleTimeSeconds, int writerIdleTimeSeconds) {
        this(socketChannel, readerIdleTimeSeconds, writerIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandler(final SocketChannel socketChannel, long readerIdleTime, long writerIdleTime, TimeUnit unit) {
        if (readerIdleTime > 0L) {
            this.pool.scheduleWithFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (IdleStateHandler.this.readerIdle) {
                        try {
                            IdleStateHandler.this.userEventTriggered(socketChannel, IdleState.READER_IDLE);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    IdleStateHandler.this.readerIdle = true;
                }
            }, 0L, readerIdleTime, unit);
        }
        if (writerIdleTime > 0L) {
            this.pool.scheduleWithFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (IdleStateHandler.this.writerIdle) {
                        try {
                            IdleStateHandler.this.userEventTriggered(socketChannel, IdleState.WRITER_IDLE);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    IdleStateHandler.this.writerIdle = true;
                }
            }, 0L, writerIdleTime, unit);
        }
    }

    public void channelRead(SocketChannel socketChannel, Object obj) throws Exception {
        this.readerIdle = false;
        super.channelRead(socketChannel, obj);
    }

    public void channelWrite(SocketChannel socketChannel, Object obj) throws Exception {
        this.writerIdle = false;
        super.channelWrite(socketChannel, obj);
    }

    public void channelClosed(SocketChannel socketChannel) throws Exception {
        this.pool.shutdown();
        super.channelClosed(socketChannel);
    }
}

