/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.traffic;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.pipeline.all.ChannelAllBoundHandlerAdapter;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import com.gettyio.core.util.ObjectUtil;
import com.gettyio.core.util.ThreadPool;
import java.util.concurrent.TimeUnit;

public class ChannelTrafficShapingHandler
extends ChannelAllBoundHandlerAdapter {
    private long totalRead;
    private long totalWrite;
    private long intervalTotalRead;
    private long intervalTotalWrite;
    long intervalTotalReadTmp = 0L;
    long intervalTotalWriteTmp = 0L;
    private long totalReadCount;
    private long totolWriteCount;
    ThreadPool pool = new ThreadPool(2, 1);

    public ChannelTrafficShapingHandler(int checkInterval) {
        this.pool.scheduleWithFixedRate(new Runnable(){

            @Override
            public void run() {
                ChannelTrafficShapingHandler.this.intervalTotalRead = ChannelTrafficShapingHandler.this.intervalTotalReadTmp;
                ChannelTrafficShapingHandler.this.intervalTotalReadTmp = 0L;
                ChannelTrafficShapingHandler.this.intervalTotalWrite = ChannelTrafficShapingHandler.this.intervalTotalWriteTmp;
                ChannelTrafficShapingHandler.this.intervalTotalWriteTmp = 0L;
            }
        }, 0L, (long)checkInterval, TimeUnit.MILLISECONDS);
    }

    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        byte[] bytes = (byte[])obj;
        this.totalRead += (long)bytes.length;
        this.intervalTotalReadTmp += (long)bytes.length;
        ++this.totalReadCount;
        super.decode(socketChannel, obj, out);
    }

    public void channelWrite(SocketChannel socketChannel, Object obj) throws Exception {
        byte[] bytes = ObjectUtil.ObjToByteArray((Object)obj);
        this.totalWrite += (long)bytes.length;
        this.intervalTotalWriteTmp += (long)bytes.length;
        ++this.totolWriteCount;
        super.channelWrite(socketChannel, obj);
    }

    public void channelClosed(SocketChannel socketChannel) throws Exception {
        this.pool.shutdown();
        super.channelClosed(socketChannel);
    }

    public long getTotalRead() {
        return this.totalRead;
    }

    public long getTotalWrite() {
        return this.totalWrite;
    }

    public long getIntervalTotalRead() {
        return this.intervalTotalRead;
    }

    public long getIntervalTotalWrite() {
        return this.intervalTotalWrite;
    }

    public long getTotalReadCount() {
        return this.totalReadCount;
    }

    public long getTotolWriteCount() {
        return this.totolWriteCount;
    }
}

