/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.dto;

public interface CommonEnum {

    public static interface IEnum<T> {
        public boolean is(T var1);

        public T get();
    }

    public static enum OptTypeEnum implements IEnum<String>
    {
        TYPE_AND("and"),
        TYPE_OR("or"),
        TYPE_NOT("not");

        public final String type;

        @Override
        public boolean is(String s) {
            return this.get().equalsIgnoreCase(s);
        }

        @Override
        public String get() {
            return this.type;
        }

        private OptTypeEnum(String type) {
            this.type = type;
        }
    }

    public static enum MethodEnum {
        METHOD_GET("GET"),
        METHOD_POST("POST"),
        METHOD_PUT("PUT"),
        METHOD_DELETE("DELETE"),
        METHOD_PATCH("PATCH"),
        METHOD_TRACE("TRACE"),
        METHOD_HEAD("HEAD"),
        METHOD_OPTIONS("OPTIONS");

        public final String method;

        private MethodEnum(String method) {
            this.method = method;
        }

        public boolean is(String method) {
            return this.method.equalsIgnoreCase(method);
        }
    }

    public static enum NetworkTypeEnum implements IEnum<Integer>
    {
        TYPE_ALL(0, "\u63a8\u9001\u65f6\u4e0d\u9650\u5236\u8054\u7f51\u65b9\u5f0f"),
        TYPE_WIFI(1, "\u4ec5wifi\u63a8\u9001");

        public final int type;
        public final String msg;

        @Override
        public boolean is(Integer integer) {
            return this.get().equals(integer);
        }

        @Override
        public Integer get() {
            return this.type;
        }

        private NetworkTypeEnum(int type, String msg) {
            this.type = type;
            this.msg = msg;
        }
    }

    public static enum ChannelLevelEnum implements IEnum<Integer>
    {
        LEVEL_ZERO(0, "<8.0, \u65e0\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u4e0d\u6d6e\u52a8; >8.0 \u65e0\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u4e0d\u663e\u793a;"),
        LEVEL_ONE(1, "<8.0, \u65e0\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u4e0d\u6d6e\u52a8; >8.0 \u65e0\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u9501\u5c4f\u4e0d\u663e\u793a\uff0c\u901a\u77e5\u680f\u4e2d\u88ab\u6298\u53e0\u663e\u793a\uff0c\u5bfc\u822a\u680f\u65e0logo;"),
        LEVEL_TWO(2, "<8.0, \u65e0\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u4e0d\u6d6e\u52a8; >8.0 \u65e0\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u9501\u5c4f\u548c\u901a\u77e5\u680f\u4e2d\u90fd\u663e\u793a\uff0c\u901a\u77e5\u4e0d\u5524\u9192\u5c4f\u5e55;"),
        LEVEL_THREE(3, "<8.0, \u6709\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u4e0d\u6d6e\u52a8; >8.0 \u6709\u58f0\u97f3\uff0c\u65e0\u632f\u52a8\uff0c\u9501\u5c4f\u548c\u901a\u77e5\u680f\u4e2d\u90fd\u663e\u793a\uff0c\u901a\u77e5\u5524\u9192\u5c4f\u5e55;"),
        LEVEL_FOUR(4, "<8.0, \u6709\u58f0\u97f3\uff0c\u6709\u632f\u52a8\uff0c\u6709\u6d6e\u52a8; >8.0 \u6709\u58f0\u97f3\uff0c\u6709\u632f\u52a8\uff0c\u4eae\u5c4f\u4e0b\u901a\u77e5\u60ac\u6d6e\u5c55\u793a\uff0c\u9501\u5c4f\u901a\u77e5\u4ee5\u9ed8\u8ba4\u5f62\u5f0f\u5c55\u793a\u4e14\u5524\u9192\u5c4f\u5e55;");

        public final int level;
        public final String msg;

        @Override
        public boolean is(Integer integer) {
            return this.get().equals(integer);
        }

        @Override
        public Integer get() {
            return null;
        }

        private ChannelLevelEnum(int level, String msg) {
            this.level = level;
            this.msg = msg;
        }
    }

    public static enum HarmonyClickTypeEnum {
        TYPE_WANT("want", "\u6253\u5f00\u5e94\u7528\u5185\u7279\u5b9a\u9875\u9762"),
        TYPE_STARTAPP("startapp", "\u6253\u5f00\u5e94\u7528\u9996\u9875");

        public final String type;
        public final String msg;

        private HarmonyClickTypeEnum(String type, String msg) {
            this.type = type;
            this.msg = msg;
        }
    }

    public static enum ClickTypeEnum {
        TYPE_INTENT("intent", "\u6253\u5f00\u5e94\u7528\u5185\u7279\u5b9a\u9875\u9762"),
        TYPE_URL("url", "\u6253\u5f00\u7f51\u9875\u5730\u5740"),
        TYPE_PAYLOAD("payload", "\u81ea\u5b9a\u4e49\u6d88\u606f\u5185\u5bb9\u542f\u52a8\u5e94\u7528"),
        TYPE_PAYLOAD_CUSTOM("payload_custom", "\u81ea\u5b9a\u4e49\u6d88\u606f\u5185\u5bb9\u4e0d\u542f\u52a8\u5e94\u7528"),
        TYPE_STARTAPP("startapp", "\u6253\u5f00\u5e94\u7528\u9996\u9875"),
        TYPE_NONE("none", "\u7eaf\u901a\u77e5\uff0c\u65e0\u540e\u7eed\u52a8\u4f5c");

        public final String type;
        public final String msg;

        private ClickTypeEnum(String type, String msg) {
            this.type = type;
            this.msg = msg;
        }
    }
}

