/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.dto.req;

import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.dto.req.BaseReqDTO;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AuthDTO
implements BaseReqDTO {
    private String sign;
    private Long timestamp;
    private String appkey;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static AuthDTO build(String appKey, String masterSecret) {
        AuthDTO authDTO = new AuthDTO();
        authDTO.appkey = appKey;
        authDTO.timestamp = System.currentTimeMillis();
        authDTO.sign = AuthDTO.sha256(appKey + authDTO.timestamp + masterSecret);
        return authDTO;
    }

    private static String sha256(String s) {
        try {
            return AuthDTO.hex(MessageDigest.getInstance("SHA-256").digest(s.getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException var3) {
            throw new AssertionError((Object)var3);
        }
    }

    public static String hex(byte[] data) {
        char[] result = new char[data.length * 2];
        int c = 0;
        for (byte b : data) {
            result[c++] = HEX_DIGITS[b >> 4 & 0xF];
            result[c++] = HEX_DIGITS[b & 0xF];
        }
        return new String(result);
    }

    @Override
    public void check() throws ApiException {
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String toString() {
        return "AuthDTO{sign='" + this.sign + '\'' + ", timestamp=" + this.timestamp + ", appkey='" + this.appkey + '\'' + '}';
    }
}

