/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance;

import com.gitee.hengboy.mybatis.enhance.common.helper.ProviderHelper;
import com.gitee.hengboy.mybatis.enhance.common.helper.StatementHelper;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import com.gitee.hengboy.mybatis.enhance.named.helper.NamedMethodHelper;
import com.gitee.hengboy.mybatis.enhance.provider.base.BaseProvider;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class MappedStatementSupport {
    static Logger logger = LoggerFactory.getLogger(MappedStatementSupport.class);

    public void support(Collection<Object> statements) {
        for (Object statementObject : statements) {
            if (!(statementObject instanceof MappedStatement)) continue;
            MappedStatement statement = (MappedStatement)statementObject;
            StatementHelper.STATEMENT_CACHE.put(statement.getId(), statement);
        }
        this.initStatementMapper();
    }

    public void namedSupport(Configuration configuration, Class<?> mapperClass) {
        Method[] methods;
        if (ObjectUtils.isEmpty(mapperClass)) {
            throw new EnhanceFrameworkException("\u5904\u7406NamedMethod MappedStatement\u65f6\uff0c\u53c2\u6570[mapperClass]\u4e3a\u5fc5\u586b\u9879.");
        }
        for (Method method : methods = mapperClass.getDeclaredMethods()) {
            String statementId = mapperClass.getName() + "." + method.getName();
            if (configuration.hasStatement(statementId) || !NamedMethodHelper.isMatchNamed(method.getName())) continue;
            logger.debug("Invoke Named Reload \uff1a {} SqlSource.", (Object)statementId);
            MappedStatement statement = new MappedStatement.Builder(configuration, statementId, (SqlSource)new DynamicSqlSource(configuration, (SqlNode)new TextSqlNode("this is empty.")), MappedStatementSupport.getSqlCommandType(method.getName())).build();
            configuration.addMappedStatement(statement);
            BaseProvider provider = ProviderHelper.getMethodProvider(statementId);
            provider.invokeNamedProviderMethod(statement);
        }
    }

    public void initStatementMapper() {
        Set<String> statementIds = StatementHelper.STATEMENT_CACHE.keySet();
        for (String statementId : statementIds) {
            MappedStatement ms = MappedStatementSupport.getStatement(statementId);
            if (StatementHelper.STATEMENT_SQL_RELOAD_CACHE.contains(statementId) || !(ms.getSqlSource() instanceof ProviderSqlSource)) continue;
            logger.debug("Invoke Reload \uff1a {} SqlSource.", (Object)ms.getId());
            BaseProvider provider = ProviderHelper.getMethodProvider(statementId);
            provider.invokeProviderMethod(ms);
            StatementHelper.STATEMENT_SQL_RELOAD_CACHE.add(statementId);
        }
    }

    public static MappedStatement getStatement(String statementId) {
        return StatementHelper.STATEMENT_CACHE.get(statementId);
    }

    private static SqlCommandType getSqlCommandType(String methodName) {
        if (NamedMethodHelper.isMatchFindNamed(methodName) || NamedMethodHelper.isMatchCountNamed(methodName)) {
            return SqlCommandType.SELECT;
        }
        if (NamedMethodHelper.isMatchDeleteNamed(methodName)) {
            return SqlCommandType.DELETE;
        }
        return SqlCommandType.UNKNOWN;
    }
}

