/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance;

import com.gitee.hengboy.mybatis.enhance.MappedStatementSupport;
import java.util.ArrayList;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class MapperFactoryBean<T>
extends SqlSessionDaoSupport
implements FactoryBean<T> {
    static Logger logger = LoggerFactory.getLogger(MapperFactoryBean.class);
    private Class<T> mapperInterface;
    private boolean addToConfig = true;
    private MappedStatementSupport mappedStatementSupport;

    public MapperFactoryBean() {
    }

    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    protected void checkDaoConfig() {
        super.checkDaoConfig();
        Assert.notNull(this.mapperInterface, (String)"Property 'mapperInterface' is required");
        Configuration configuration = this.getSqlSession().getConfiguration();
        if (this.addToConfig && !configuration.hasMapper(this.mapperInterface)) {
            try {
                configuration.addMapper(this.mapperInterface);
            }
            catch (Exception var6) {
                logger.error("Error while adding the mapper '" + this.mapperInterface + "' to configuration.", (Throwable)var6);
                throw new IllegalArgumentException(var6);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        if (configuration.hasMapper(this.mapperInterface)) {
            logger.debug("Start initializing the MappedStatement list within >> {} << .", (Object)this.mapperInterface.getName());
            this.mappedStatementSupport.support(new ArrayList<Object>(configuration.getMappedStatements()));
            logger.debug("All the MappedStatement SqlSource loading in >> {} << is completed.", (Object)this.mapperInterface.getName());
            logger.debug("Start initializing the Named Method MappedStatement list within >> {} << .", (Object)this.mapperInterface.getName());
            this.mappedStatementSupport.namedSupport(configuration, this.mapperInterface);
            logger.debug("All the Named Method MappedStatement SqlSource loading in >> {} << is completed.", (Object)this.mapperInterface.getName());
        }
    }

    public T getObject() throws Exception {
        return (T)this.getSqlSession().getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public Class<T> getMapperInterface() {
        return this.mapperInterface;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public boolean isAddToConfig() {
        return this.addToConfig;
    }

    public MappedStatementSupport getMappedStatementSupport() {
        return this.mappedStatementSupport;
    }

    public void setMappedStatementSupport(MappedStatementSupport mappedStatementSupport) {
        this.mappedStatementSupport = mappedStatementSupport;
    }
}

