/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper;

import com.gitee.hengboy.mybatis.enhance.common.annotation.Column;
import com.gitee.hengboy.mybatis.enhance.common.annotation.Id;
import com.gitee.hengboy.mybatis.enhance.common.enums.KeyGeneratorTypeEnum;
import com.gitee.hengboy.mybatis.enhance.common.helper.ReflectionHelper;
import com.gitee.hengboy.mybatis.enhance.common.struct.ColumnStruct;
import com.gitee.hengboy.mybatis.enhance.common.struct.TableStruct;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ColumnHelper {
    static Logger logger = LoggerFactory.getLogger(ColumnHelper.class);

    public static String getColumnName(Field field) {
        Column column = field.getAnnotation(Column.class);
        String columnName = field.getName();
        if (column != null && !StringUtils.isEmpty((Object)column.name())) {
            columnName = column.name();
        }
        return columnName;
    }

    public static boolean getIsPk(Field field) {
        Id id = field.getAnnotation(Id.class);
        return id != null;
    }

    public static KeyGeneratorTypeEnum getGeneratorType(Field field) {
        if (ColumnHelper.getIsPk(field)) {
            Id id = field.getAnnotation(Id.class);
            return id.generatorType();
        }
        return null;
    }

    public static boolean getMapping(Field field) {
        Column column = field.getAnnotation(Column.class);
        return column == null ? true : column.mapping();
    }

    public static boolean getInsertable(Field field) {
        Column column = field.getAnnotation(Column.class);
        return column == null ? true : column.insertable();
    }

    public static boolean getUpdateable(Field field) {
        Column column = field.getAnnotation(Column.class);
        return column == null ? true : column.updateable();
    }

    public static ColumnStruct getStruct(Field field) {
        ColumnStruct struct = new ColumnStruct();
        struct.setColumnName(ColumnHelper.getColumnName(field));
        struct.setFieldName(field.getName());
        struct.setPk(ColumnHelper.getIsPk(field));
        struct.setMapping(ColumnHelper.getMapping(field));
        struct.setInsertable(ColumnHelper.getInsertable(field));
        struct.setUpdateable(ColumnHelper.getUpdateable(field));
        struct.setGeneratorType(ColumnHelper.getGeneratorType(field));
        struct.setJavaType(field.getType());
        return struct;
    }

    static List<ColumnStruct> loadColumnStruct(TableStruct tableStruct, Class<?> entityClass) {
        ArrayList<ColumnStruct> structs = new ArrayList<ColumnStruct>();
        List<Field> fields = ReflectionHelper.getAllFields(entityClass);
        for (Field field : fields) {
            if (!Modifier.isPrivate(field.getModifiers())) {
                logger.warn("load column struct\uff1a{}\uff0cfaild\uff0creason\uff1a{}", (Object)(entityClass.getName() + "." + field.getName()), (Object)"only load private field!");
                continue;
            }
            ColumnStruct struct = ColumnHelper.getStruct(field);
            if (struct.isPk()) {
                tableStruct.setIdName(struct.getColumnName());
                tableStruct.setIdFieldName(field.getName());
            }
            structs.add(struct);
        }
        return structs;
    }
}

