/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper;

import com.gitee.hengboy.mybatis.enhance.mapper.EnhanceMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.SoftCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.springframework.util.ObjectUtils;

public class EntityHelper {
    private static Cache ENTITY_CLASS_CACHE = new SoftCache((Cache)new PerpetualCache("ENTITY_CLASS_CACHE"));

    public static Class<?> getEntityClass(Class<?> mapperClass) {
        Class<?> modelClass = EntityHelper.getCacheEntityClass(mapperClass);
        if (!ObjectUtils.isEmpty(modelClass)) {
            return modelClass;
        }
        return EntityHelper.getMapperEntityClass(mapperClass);
    }

    private static Class<?> getCacheEntityClass(Class<?> mapperClass) {
        return (Class)ENTITY_CLASS_CACHE.getObject((Object)mapperClass.getName());
    }

    private static Class<?> getMapperEntityClass(Class<?> mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(EnhanceMapper.class)) continue;
            target = (ParameterizedType)type;
            break;
        }
        Type[] parameters = target.getActualTypeArguments();
        Class modelClass = (Class)parameters[0];
        ENTITY_CLASS_CACHE.putObject((Object)mapperClass.getName(), (Object)modelClass);
        return modelClass;
    }
}

