/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper;

import com.gitee.hengboy.mybatis.enhance.common.annotation.Table;
import com.gitee.hengboy.mybatis.enhance.common.helper.ColumnHelper;
import com.gitee.hengboy.mybatis.enhance.common.helper.NameDefineHelper;
import com.gitee.hengboy.mybatis.enhance.common.struct.ColumnStruct;
import com.gitee.hengboy.mybatis.enhance.common.struct.TableStruct;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.util.List;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.SoftCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class TableHelper {
    private static Cache TABLE_CACHE = new SoftCache((Cache)new PerpetualCache("TABLE_CACHE"));
    private static Cache COLUMN_CACHE = new SoftCache((Cache)new PerpetualCache("COLUMN_CACHE"));

    public static TableStruct getTableStruct(Class<?> entityClass) throws EnhanceFrameworkException {
        Object object = TABLE_CACHE.getObject((Object)entityClass.getName());
        if (!ObjectUtils.isEmpty((Object)object)) {
            return (TableStruct)object;
        }
        TableStruct tableStruct = TableHelper.loadTableStruct(entityClass);
        TABLE_CACHE.putObject((Object)entityClass.getName(), (Object)tableStruct);
        return tableStruct;
    }

    public static List<ColumnStruct> getColumnStruct(Class<?> entityClass) throws EnhanceFrameworkException {
        Object object = COLUMN_CACHE.getObject((Object)entityClass.getName());
        if (!ObjectUtils.isEmpty((Object)object)) {
            return (List)object;
        }
        TableStruct tableStruct = TableHelper.getTableStruct(entityClass);
        List<ColumnStruct> columns = ColumnHelper.loadColumnStruct(tableStruct, entityClass);
        COLUMN_CACHE.putObject((Object)entityClass.getName(), columns);
        return columns;
    }

    static TableStruct loadTableStruct(Class<?> entityClass) throws EnhanceFrameworkException {
        TableStruct tableStruct = new TableStruct();
        tableStruct.setTableName(TableHelper.getTableName(entityClass));
        List<ColumnStruct> columns = ColumnHelper.loadColumnStruct(tableStruct, entityClass);
        COLUMN_CACHE.putObject((Object)entityClass.getName(), columns);
        return tableStruct;
    }

    public static String getTableName(Class<?> entityClass) {
        if (entityClass == null) {
            throw new EnhanceFrameworkException("The parameter\uff1a[entityClass] is null\uff0cgetTableName Faild!");
        }
        String tableName = NameDefineHelper.camelToUnderline(entityClass.getSimpleName());
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null && !StringUtils.isEmpty((Object)table.name())) {
            tableName = table.name();
        }
        return tableName;
    }
}

