/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper.sql;

import com.gitee.hengboy.mybatis.enhance.common.enums.PlaceholderEnum;
import com.gitee.hengboy.mybatis.enhance.common.struct.ColumnStruct;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import com.gitee.hengboy.mybatis.enhance.named.OrPart;
import com.gitee.hengboy.mybatis.enhance.named.helper.NamedMethodHelper;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MapperXmlMySqlHelper {
    public static String script(String expression, String ... expressions) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)expression)) {
            throw new EnhanceFrameworkException("\u751f\u6210xml\u5f62\u5f0f\u7684sql\u65f6\u8bf7\u81f3\u5c11\u4f20\u9012\u4e00\u4e2a[expression].");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<script>");
        buffer.append(expression);
        if (!ObjectUtils.isEmpty((Object[])expressions)) {
            for (String content : expressions) {
                buffer.append(content);
            }
        }
        buffer.append("</script>");
        return buffer.toString();
    }

    public static String named(String methodName, Map<String, ColumnStruct> columnMappings) throws EnhanceFrameworkException {
        StringBuffer buffer = new StringBuffer();
        List<OrPart> orParts = NamedMethodHelper.getNamedWhereSql(methodName, columnMappings);
        if (!ObjectUtils.isEmpty(orParts)) {
            for (int j = 0; j < orParts.size(); ++j) {
                OrPart orPart = orParts.get(j);
                List<String> predicates = orPart.getPredicates();
                for (int i = 0; i < predicates.size(); ++i) {
                    buffer.append(predicates.get(i));
                    if (i >= predicates.size() - 1) continue;
                    buffer.append(PlaceholderEnum.AND.getValue());
                }
                if (j >= orParts.size() - 1) continue;
                buffer.append(PlaceholderEnum.OR.getValue());
            }
        }
        return buffer.toString();
    }

    public static String update(String tableName) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)tableName)) {
            throw new EnhanceFrameworkException("\u751f\u6210update\u8868\u8fbe\u5f0f\u65f6\uff0c\u8bf7\u4f20\u9012[tableName].");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(PlaceholderEnum.UPDATE.getValue());
        buffer.append(tableName);
        return buffer.toString();
    }

    public static String delete(String tableName) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)tableName)) {
            throw new EnhanceFrameworkException("\u751f\u6210deleteFrom\u8868\u8fbe\u5f0f\u65f6\uff0c\u8bf7\u4f20\u9012[tableName].");
        }
        return PlaceholderEnum.DELETE_FROM.getValue() + tableName;
    }

    public static String select(String tableName, String[] columns) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)tableName)) {
            throw new EnhanceFrameworkException("\u751f\u6210selectFrom\u8868\u8fbe\u5f0f\u65f6\uff0c\u8bf7\u4f20\u9012[tableName].");
        }
        if (ObjectUtils.isEmpty((Object[])columns)) {
            throw new EnhanceFrameworkException("\u751f\u6210selectFrom\u8868\u8fbe\u5f0f\u65f6\uff0c\u8bf7\u4f20\u9012[columns].");
        }
        return ((SQL)((SQL)new SQL().SELECT(columns)).FROM(tableName)).toString();
    }

    public static String set(String ... expressions) throws EnhanceFrameworkException {
        if (ObjectUtils.isEmpty((Object[])expressions)) {
            throw new EnhanceFrameworkException("\u751f\u6210update\u8868\u8fbe\u5f0f\u65f6\uff0c\u8bf7\u4f20\u9012[sets].");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<set>");
        for (String set : expressions) {
            buffer.append(set);
            buffer.append(PlaceholderEnum.SPLIT.getValue());
        }
        buffer.append("</set>");
        return buffer.toString();
    }

    public static String where(String expression, String ... expressions) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)expression) && ObjectUtils.isEmpty((Object[])expressions)) {
            throw new EnhanceFrameworkException("where\u8868\u8fbe\u5f0f\u751f\u6210\u65f6\u8bf7\u81f3\u5c11\u4f20\u9012\u4e00\u4e2a[expression]\u8868\u8fbe\u5f0f.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<where>");
        buffer.append(expression);
        if (!ObjectUtils.isEmpty((Object[])expressions)) {
            for (String express : expressions) {
                buffer.append(express);
            }
        }
        buffer.append("</where>");
        return buffer.toString();
    }

    public static String ifNotNull(String paramName, String expression, String ... expressions) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)expression) && ObjectUtils.isEmpty((Object[])expressions)) {
            throw new EnhanceFrameworkException("if\u8868\u8fbe\u5f0f\u751f\u6210\u65f6\u8bf7\u81f3\u5c11\u4f20\u9012\u4e00\u4e2a[content].");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<if test='");
        buffer.append(paramName);
        buffer.append("!=null'>");
        buffer.append(expression);
        if (!ObjectUtils.isEmpty((Object[])expressions)) {
            for (String content : expressions) {
                buffer.append(content);
            }
        }
        buffer.append("</if>");
        return buffer.toString();
    }

    public static String in(String columnName, String collection, String item) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)columnName)) {
            throw new EnhanceFrameworkException("in\u8868\u8fbe\u5f0f\u751f\u6210\u65f6\u9700\u8981\u4f20\u9012[columnName]\u53c2\u6570.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(columnName);
        buffer.append(PlaceholderEnum.IN.getValue());
        buffer.append(MapperXmlMySqlHelper.foreach(collection, item, "(", ")", ","));
        return MapperXmlMySqlHelper.ifNotNull(collection, buffer.toString(), new String[0]);
    }

    public static String foreach(String collection, String item, String open, String close, String separator) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)collection) || StringUtils.isEmpty((Object)item) || StringUtils.isEmpty((Object)separator)) {
            throw new EnhanceFrameworkException("\u8bf7\u68c0\u67e5[collection]\u3001[item]\u3001[separator]\u7b49\u53c2\u6570\u662f\u5426\u4f20\u9012.");
        }
        StringBuffer sqlBuffer = new StringBuffer("<foreach ");
        sqlBuffer.append("collection = '");
        sqlBuffer.append(collection);
        sqlBuffer.append("' item = '");
        sqlBuffer.append(item);
        if (!StringUtils.isEmpty((Object)open)) {
            sqlBuffer.append("' open = '");
            sqlBuffer.append(open);
        }
        if (!StringUtils.isEmpty((Object)close)) {
            sqlBuffer.append("' close = '");
            sqlBuffer.append(close);
        }
        sqlBuffer.append("' separator = '");
        sqlBuffer.append(separator);
        sqlBuffer.append("'>");
        sqlBuffer.append("#{");
        sqlBuffer.append(item);
        sqlBuffer.append("}");
        sqlBuffer.append("</foreach>");
        return sqlBuffer.toString();
    }

    public static String pageable() throws EnhanceFrameworkException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PlaceholderEnum.LIMIT.getValue());
        buffer.append(MapperXmlMySqlHelper.ifNotNull("pageable.offset", "#{pageable.offset}" + PlaceholderEnum.SPLIT.getValue(), new String[0]));
        buffer.append("#{pageable.limit}");
        return MapperXmlMySqlHelper.ifNotNull("pageable.limit", buffer.toString(), new String[0]);
    }

    public static String sort() throws EnhanceFrameworkException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PlaceholderEnum.ORDER_BY.getValue());
        buffer.append("${pageable.sort.sorter}");
        return MapperXmlMySqlHelper.ifNotNull("pageable.sort", MapperXmlMySqlHelper.ifNotNull("pageable.sort.column", buffer.toString(), new String[0]), new String[0]);
    }

    public static String count(String tableName, String columnName) throws EnhanceFrameworkException {
        if (StringUtils.isEmpty((Object)tableName) || StringUtils.isEmpty((Object)columnName)) {
            throw new EnhanceFrameworkException("\u8bf7\u68c0\u67e5[tableName]\u3001[columnName]\u7b49\u53c2\u6570\u662f\u5426\u4f20\u9012.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(PlaceholderEnum.SELECT.getValue());
        buffer.append(PlaceholderEnum.COUNT.getValue());
        buffer.append(PlaceholderEnum.SPLIT_PREFIX.getValue().trim());
        buffer.append(columnName);
        buffer.append(PlaceholderEnum.SPLIT_SUFFIX.getValue().trim());
        buffer.append(PlaceholderEnum.FROM.getValue());
        buffer.append(tableName);
        return buffer.toString();
    }
}

