/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.key.generator;

import com.gitee.hengboy.mybatis.enhance.common.helper.StatementHelper;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.springframework.util.ObjectUtils;

public class SelectAutoKeyGenerator
implements KeyGenerator {
    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        try {
            String selectKeySql = "select last_insert_id()";
            Configuration configuration = ms.getConfiguration();
            Executor keyExecutor = configuration.newExecutor(executor.getTransaction(), ExecutorType.SIMPLE);
            MappedStatement statement = StatementHelper.createSelectKeyStatement(ms.getConfiguration(), ms.getId(), selectKeySql);
            ResultMap.Builder builder = new ResultMap.Builder(statement.getConfiguration(), statement.getId() + "-Inline", Integer.class, new ArrayList(), Boolean.valueOf(true));
            ResultMap resultMap = builder.build();
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            metaObject.setValue("resultMaps", Collections.unmodifiableList(Arrays.asList(resultMap)));
            List values = keyExecutor.query(statement, parameter, RowBounds.DEFAULT, Executor.NO_RESULT_HANDLER);
            this.batchProcessAfter(ms, this.getParameters(parameter), values.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void batchProcessAfter(MappedStatement ms, Collection<Object> parameters, Object autoValue) {
        Object[] keyProperties = ms.getKeyProperties();
        if (ObjectUtils.isEmpty((Object[])keyProperties)) {
            throw new EnhanceFrameworkException("\u5e76\u672a\u8bbe\u7f6e\u4e3b\u952e\u5b57\u6bb5\uff0c\u65e0\u6cd5\u6839\u636e\u4e3b\u952e\u7b56\u7565\u751f\u6210\u5bf9\u5e94\u7684\u4e3b\u952e\u503c.");
        }
        Configuration configuration = ms.getConfiguration();
        for (Object parameter : parameters) {
            MetaObject metaParam = configuration.newMetaObject(parameter);
            this.setValue(metaParam, (String)keyProperties[0], autoValue);
        }
    }

    private void setValue(MetaObject metaParam, String property, Object value) {
        if (!metaParam.hasSetter(property)) {
            throw new ExecutorException("No setter found for the keyProperty '" + property + "' in " + metaParam.getOriginalObject().getClass().getName() + ".");
        }
        metaParam.setValue(property, value);
    }

    private Collection<Object> getParameters(Object parameter) {
        Collection<Object> parameters = null;
        if (parameter instanceof Collection) {
            parameters = (ArrayList<Object>)parameter;
        } else if (parameter instanceof Map) {
            Map parameterMap = (Map)parameter;
            if (parameterMap.containsKey("collection")) {
                Object collection = parameterMap.get("collection");
                if (collection instanceof Collection) {
                    parameters = (Collection)collection;
                } else if (collection instanceof Object[]) {
                    parameters = Arrays.asList((Object[])collection);
                }
            } else if (parameterMap.containsKey("list")) {
                parameters = (List)parameterMap.get("list");
            } else if (parameterMap.containsKey("array")) {
                parameters = Arrays.asList((Object[])parameterMap.get("array"));
            } else if (parameterMap.containsKey("bean")) {
                parameters = Arrays.asList(parameterMap.get("bean"));
            }
        }
        if (parameters == null) {
            parameters = new ArrayList<Object>();
            parameters.add(parameter);
        }
        return parameters;
    }
}

