/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.boot.aspect;

import com.gitegg.platform.base.annotation.resubmit.ResubmitLock;
import com.gitegg.platform.base.enums.ResultCodeEnum;
import com.gitegg.platform.base.exception.SystemException;
import com.gitegg.platform.base.util.JsonUtils;
import com.gitegg.platform.boot.util.ExpressionUtils;
import com.gitegg.platform.boot.util.GitEggAuthUtils;
import com.gitegg.platform.boot.util.GitEggWebUtils;
import com.gitegg.platform.redis.lock.IDistributedLockService;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
@Aspect
@ConditionalOnProperty(name={"enabled"}, prefix="resubmit-lock", havingValue="true", matchIfMissing=true)
public class ResubmitLockAspect {
    private static final Logger log = LogManager.getLogger(ResubmitLockAspect.class);
    private static final String REDIS_SEPARATOR = ":";
    private static final String RESUBMIT_CHECK_KEY_PREFIX = "resubmit_lock:";
    private final IDistributedLockService distributedLockService;

    @Pointcut(value="@annotation(com.gitegg.platform.base.annotation.resubmit.ResubmitLock)")
    public void resubmitLock() {
    }

    @Before(value="@annotation(resubmitLock)")
    public Object resubmitCheck(JoinPoint joinPoint, ResubmitLock resubmitLock) throws Throwable {
        String[] conditions;
        Object[] args = joinPoint.getArgs();
        if (!ExpressionUtils.getConditionValue((Object)args, conditions = resubmitLock.conditions()) || ArrayUtils.isEmpty((Object[])args)) {
            return ((ProceedingJoinPoint)joinPoint).proceed();
        }
        this.doCheck(resubmitLock, args);
        return ((ProceedingJoinPoint)joinPoint).proceed();
    }

    private void doCheck(@NonNull ResubmitLock resubmitLock, Object[] args) {
        Object[] keys = resubmitLock.keys();
        boolean currentUser = resubmitLock.currentUser();
        boolean currentSession = resubmitLock.currentSession();
        String method = GitEggWebUtils.getRequest().getMethod();
        String uri = GitEggWebUtils.getRequest().getRequestURI();
        StringBuffer lockKeyBuffer = new StringBuffer(RESUBMIT_CHECK_KEY_PREFIX);
        if (null != GitEggAuthUtils.getTenantId()) {
            lockKeyBuffer.append(GitEggAuthUtils.getTenantId()).append(REDIS_SEPARATOR);
        }
        if (currentSession) {
            lockKeyBuffer.append(GitEggWebUtils.getSessionId()).append(REDIS_SEPARATOR);
        }
        if (currentUser && null != GitEggAuthUtils.getCurrentUser()) {
            lockKeyBuffer.append(GitEggAuthUtils.getCurrentUser().getId()).append(REDIS_SEPARATOR);
        }
        lockKeyBuffer.append(uri).append(REDIS_SEPARATOR).append(method);
        StringBuffer parametersBuffer = new StringBuffer();
        if (ArrayUtils.isNotEmpty((Object[])keys)) {
            T[] argsForKey;
            for (Object obj : argsForKey = ExpressionUtils.getExpressionValue((Object)args, (String[])keys)) {
                parametersBuffer.append(REDIS_SEPARATOR).append(String.valueOf(obj));
            }
        } else {
            String[] ignoreKeys = resubmitLock.ignoreKeys();
            int[] argsIndex = resubmitLock.argsIndex();
            if (ArrayUtils.isNotEmpty((int[])argsIndex)) {
                for (int index : argsIndex) {
                    parametersBuffer.append(REDIS_SEPARATOR).append(ResubmitLockAspect.getKeyAndValueJsonStr(args[index], ignoreKeys));
                }
            } else {
                for (Object obj : args) {
                    parametersBuffer.append(REDIS_SEPARATOR).append(ResubmitLockAspect.getKeyAndValueJsonStr(obj, ignoreKeys));
                }
            }
        }
        String parametersKey = DigestUtils.md5DigestAsHex((byte[])parametersBuffer.toString().getBytes());
        lockKeyBuffer.append(parametersKey);
        try {
            boolean isLock = this.distributedLockService.tryLock(lockKeyBuffer.toString(), 0L, resubmitLock.interval(), resubmitLock.timeUnit());
            if (!isLock) {
                throw new SystemException(ResultCodeEnum.RESUBMIT_LOCK.code, ResultCodeEnum.RESUBMIT_LOCK.msg);
            }
        }
        catch (InterruptedException e) {
            throw new SystemException(ResultCodeEnum.RESUBMIT_LOCK.code, ResultCodeEnum.RESUBMIT_LOCK.msg);
        }
    }

    public static String getKeyAndValueJsonStr(Object obj, String[] ignoreKeys) {
        HashMap map = Maps.newHashMap();
        Class<?> objCla = obj.getClass();
        Field[] fs = objCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            Object val = new Object();
            try {
                String filedName = f.getName();
                if (null != ignoreKeys && Arrays.asList(ignoreKeys).contains(filedName)) continue;
                val = f.get(obj);
                map.put(filedName, val);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.error("getKeyAndValue IllegalArgumentException", (Throwable)e);
                throw new RuntimeException("\u60a8\u7684\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            catch (IllegalAccessException e) {
                log.error("getKeyAndValue IllegalAccessException", (Throwable)e);
                throw new RuntimeException("\u60a8\u7684\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Map<String, Object> sortMap = ResubmitLockAspect.sortMapByKey(map);
        String mapStr = JsonUtils.mapToJson(sortMap);
        return mapStr;
    }

    private static Map<String, Object> sortMapByKey(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    @Autowired
    public ResubmitLockAspect(IDistributedLockService distributedLockService) {
        this.distributedLockService = distributedLockService;
    }
}

