/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.boot.common.advice;

import com.gitegg.platform.base.enums.ResultCodeEnum;
import com.gitegg.platform.base.exception.BusinessException;
import com.gitegg.platform.base.exception.SystemException;
import com.gitegg.platform.base.result.Result;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.ui.Model;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GitEggControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(GitEggControllerAdvice.class);
    @Value(value="${spring.application.name}")
    private String serverName;
    private String errorSystem;

    @PostConstruct
    public void init() {
        this.errorSystem = new StringBuffer().append(this.serverName).append(": ").toString();
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    @ModelAttribute
    public void addAttributes(Model model) {
    }

    @ExceptionHandler(value={Exception.class})
    public Result handlerException(Exception exception, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u8def\u5f84uri={},\u7cfb\u7edf\u5185\u90e8\u51fa\u73b0\u5f02\u5e38:{}", (Object)request.getRequestURI(), (Object)exception);
        Result result = Result.error((ResultCodeEnum)ResultCodeEnum.ERROR, (String)(this.errorSystem + exception.getLocalizedMessage()));
        return result;
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class, HttpMediaTypeNotSupportedException.class, HttpRequestMethodNotSupportedException.class, MissingServletRequestParameterException.class, NoHandlerFoundException.class, MissingPathVariableException.class, HttpMessageNotReadableException.class})
    public Result handlerSpringAOPException(Exception exception) {
        log.error("\u975e\u6cd5\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)exception);
        Result result = Result.error((ResultCodeEnum)ResultCodeEnum.ILLEGAL_REQUEST, (String)(this.errorSystem + exception.getLocalizedMessage()));
        return result;
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Result handlerSpringAOPException(MethodArgumentTypeMismatchException exception) {
        log.error("\u975e\u6cd5\u8bf7\u6c42\u5f02\u5e38-\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d:{}", (Throwable)exception);
        Result result = Result.error((ResultCodeEnum)ResultCodeEnum.PARAM_TYPE_MISMATCH, (String)(this.errorSystem + exception.getLocalizedMessage()));
        return result;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result handlerMethodArgumentNotValidException(MethodArgumentNotValidException methodArgumentNotValidException) {
        StringBuffer stringBuffer = new StringBuffer();
        methodArgumentNotValidException.getBindingResult().getFieldErrors().stream().map(t -> t.getField() + t.getDefaultMessage() + ";").forEach(e -> stringBuffer.append((String)e));
        String errorMessage = stringBuffer.toString();
        log.error("\u975e\u6cd5\u8bf7\u6c42\u5f02\u5e38-\u53c2\u6570\u6821\u9a8c\u5f02\u5e38:{}", (Object)errorMessage);
        Result result = Result.error((ResultCodeEnum)ResultCodeEnum.PARAM_VALID_ERROR, (String)(this.errorSystem + errorMessage));
        return result;
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result handlerConstraintViolationException(ConstraintViolationException constraintViolationException) {
        String errorMessage = constraintViolationException.getLocalizedMessage();
        log.error("\u975e\u6cd5\u8bf7\u6c42\u5f02\u5e38-\u53c2\u6570\u6821\u9a8c\u5f02\u5e38:{}", (Object)errorMessage);
        Result result = Result.error((ResultCodeEnum)ResultCodeEnum.PARAM_VALID_ERROR, (String)(this.errorSystem + errorMessage));
        return result;
    }

    @ExceptionHandler(value={BusinessException.class})
    public Result handlerCustomException(BusinessException exception) {
        String errorMessage = exception.getMsg();
        log.error("\u64cd\u4f5c\u5f02\u5e38:{}", (Object)errorMessage);
        Result result = Result.error((int)exception.getCode(), (String)(this.errorSystem + errorMessage));
        return result;
    }

    @ExceptionHandler(value={SystemException.class})
    public Result handlerCustomException(SystemException exception) {
        String errorMessage = exception.getMsg();
        log.error("\u7cfb\u7edf\u5f02\u5e38:{}", (Object)errorMessage);
        Result result = Result.error((int)exception.getCode(), (String)(this.errorSystem + errorMessage));
        return result;
    }
}

