/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.boot.common.task;

import com.gitegg.platform.boot.common.task.ThreadLocalRequestHeaderContext;
import com.gitegg.platform.boot.util.GitEggWebUtils;
import java.util.Map;
import org.springframework.core.task.TaskDecorator;

public class RequestHeaderTaskDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        try {
            Map<String, String> requestHeaders = GitEggWebUtils.getHeaders(GitEggWebUtils.getRequest());
            return () -> {
                try {
                    ThreadLocalRequestHeaderContext.set(requestHeaders);
                    runnable.run();
                }
                finally {
                    ThreadLocalRequestHeaderContext.remove();
                }
            };
        }
        catch (IllegalStateException e) {
            return runnable;
        }
    }
}

