/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.boot.util;

import cn.hutool.json.JSONUtil;
import com.gitegg.platform.base.domain.GitEggUser;
import com.gitegg.platform.boot.common.task.ThreadLocalRequestHeaderContext;
import com.gitegg.platform.boot.util.GitEggWebUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GitEggAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(GitEggAuthUtils.class);

    public static GitEggUser getCurrentUser() {
        HttpServletRequest request = GitEggWebUtils.getRequest();
        String user = null != request && !StringUtils.isEmpty((Object)request.getHeader("User")) ? request.getHeader("User") : GitEggAuthUtils.getThreadPoolContextValue("User");
        if (StringUtils.isEmpty((Object)user)) {
            return null;
        }
        try {
            String userStr = URLDecoder.decode(user, "UTF-8");
            GitEggUser gitEggUser = (GitEggUser)JSONUtil.toBean((String)userStr, GitEggUser.class);
            return gitEggUser;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    public static String getTenantId() {
        HttpServletRequest request = GitEggWebUtils.getRequest();
        try {
            if (null != request && !StringUtils.isEmpty((Object)request.getHeader("TenantId"))) {
                return request.getHeader("TenantId");
            }
            GitEggUser gitEggUser = GitEggAuthUtils.getCurrentUser();
            if (null != gitEggUser) {
                return gitEggUser.getTenantId();
            }
            String tenantId = GitEggAuthUtils.getThreadPoolContextValue("TenantId");
            return tenantId;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    private static String getThreadPoolContextValue(String headerKey) {
        Map<String, String> headers = ThreadLocalRequestHeaderContext.get();
        if (null != headers) {
            return headers.get(headerKey.toLowerCase());
        }
        return null;
    }
}

