/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.redis.lock.impl;

import com.gitegg.platform.redis.lock.IDistributedLockService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributedLockServiceImpl
implements IDistributedLockService {
    private final RedissonClient redissonClient;

    @Override
    public void lock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock();
    }

    @Override
    public void unlock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.unlock();
    }

    @Override
    public void lock(String lockKey, int timeout) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock((long)timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void lock(String lockKey, int timeout, TimeUnit unit) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock((long)timeout, unit);
    }

    @Override
    public boolean tryLock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        return lock.tryLock();
    }

    @Override
    public boolean tryLock(String lockKey, long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        RLock lock = this.redissonClient.getLock(lockKey);
        return lock.tryLock(waitTime, leaseTime, unit);
    }

    @Override
    public boolean isLocked(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        return lock.isLocked();
    }

    @Autowired
    public DistributedLockServiceImpl(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

