/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.dfs.minio.service.impl;

import com.gitegg.platform.base.util.JsonUtils;
import com.gitegg.platform.dfs.constant.DfsConstants;
import com.gitegg.platform.dfs.domain.GitEggDfsFile;
import com.gitegg.platform.dfs.minio.props.MinioDfsProperties;
import com.gitegg.platform.dfs.service.IDfsBaseService;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.DeleteObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MinioDfsServiceImpl
implements IDfsBaseService {
    private static final Logger log = LoggerFactory.getLogger(MinioDfsServiceImpl.class);
    private final MinioClient minioClient;
    private final MinioDfsProperties minioDfsProperties;

    public String uploadToken(String bucket) {
        return null;
    }

    public String uploadToken(String bucket, String key) {
        return null;
    }

    public void createBucket(String bucket) {
        BucketExistsArgs bea = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build();
        try {
            if (!this.minioClient.bucketExists(bea)) {
                MakeBucketArgs mba = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build();
                this.minioClient.makeBucket(mba);
            }
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
    }

    public GitEggDfsFile uploadFile(InputStream inputStream, String fileName) {
        return this.uploadFile(inputStream, this.minioDfsProperties.getBucket(), fileName);
    }

    public GitEggDfsFile uploadFile(InputStream inputStream, String bucket, String fileName) {
        GitEggDfsFile dfsFile = new GitEggDfsFile();
        try {
            dfsFile.setBucket(bucket);
            dfsFile.setBucketDomain(this.minioDfsProperties.getUploadUrl());
            dfsFile.setFileUrl(this.minioDfsProperties.getAccessUrlPrefix());
            dfsFile.setEncodedFileName(fileName);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).stream(inputStream, -1L, 0x500000L).object(fileName)).build());
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        return dfsFile;
    }

    public String getFileUrl(String fileName) {
        return this.getFileUrl(this.minioDfsProperties.getBucket(), fileName);
    }

    public String getFileUrl(String bucket, String fileName) {
        return this.getFileUrl(bucket, fileName, 2, DfsConstants.DFS_FILE_DURATION_UNIT);
    }

    public String getFileUrl(String bucket, String fileName, int duration, TimeUnit unit) {
        String url = null;
        try {
            url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucket)).object(fileName)).expiry(duration, unit).build());
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        return url;
    }

    public OutputStream getFileObject(String fileName, OutputStream outputStream) {
        return this.getFileObject(this.minioDfsProperties.getBucket(), fileName, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getFileObject(String bucket, String fileName, OutputStream outputStream) {
        BufferedInputStream bis = null;
        InputStream stream = null;
        try {
            stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(fileName)).build());
            bis = new BufferedInputStream(stream);
            IOUtils.copy((InputStream)bis, (OutputStream)outputStream);
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return outputStream;
    }

    public String removeFile(String fileName) {
        return this.removeFile(this.minioDfsProperties.getBucket(), fileName);
    }

    public String removeFile(String bucket, String fileName) {
        return this.removeFiles(bucket, Collections.singletonList(fileName));
    }

    public String removeFiles(List<String> fileNames) {
        return this.removeFiles(this.minioDfsProperties.getBucket(), fileNames);
    }

    public String removeFiles(String bucket, List<String> fileNames) {
        ArrayList deleteObject = new ArrayList();
        if (!CollectionUtils.isEmpty(fileNames)) {
            fileNames.stream().forEach(item -> deleteObject.add(new DeleteObject(item)));
        }
        Iterable result = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucket)).objects(deleteObject).build());
        try {
            return JsonUtils.objToJsonIgnoreNull((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MinioDfsServiceImpl(MinioClient minioClient, MinioDfsProperties minioDfsProperties) {
        this.minioClient = minioClient;
        this.minioDfsProperties = minioDfsProperties;
    }
}

