/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.oauth2.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Oauth2Token")
public class Oauth2Token {
    @ApiModelProperty(value="\u8bbf\u95ee\u4ee4\u724c")
    private String token;
    @ApiModelProperty(value="\u5237\u65b0\u4ee4\u724c")
    private String refreshToken;
    @ApiModelProperty(value="\u8bbf\u95ee\u4ee4\u724c\u5934\u524d\u7f00")
    private String tokenHead;
    @ApiModelProperty(value="token\u6709\u6548\u65f6\u95f4\uff08\u79d2\uff09")
    private int expiresIn;
    @ApiModelProperty(value="token\u8fc7\u671f\u65f6\u95f4")
    private Long exp;
    @ApiModelProperty(value="refreshToken\u6709\u6548\u65f6\u95f4\uff08\u79d2\uff09")
    private int refreshExpiresIn;
    @ApiModelProperty(value="refreshToken\u8fc7\u671f\u65f6\u95f4")
    private Long refreshExp;

    Oauth2Token(String token, String refreshToken, String tokenHead, int expiresIn, Long exp, int refreshExpiresIn, Long refreshExp) {
        this.token = token;
        this.refreshToken = refreshToken;
        this.tokenHead = tokenHead;
        this.expiresIn = expiresIn;
        this.exp = exp;
        this.refreshExpiresIn = refreshExpiresIn;
        this.refreshExp = refreshExp;
    }

    public static Oauth2TokenBuilder builder() {
        return new Oauth2TokenBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenHead() {
        return this.tokenHead;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public Long getExp() {
        return this.exp;
    }

    public int getRefreshExpiresIn() {
        return this.refreshExpiresIn;
    }

    public Long getRefreshExp() {
        return this.refreshExp;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setTokenHead(String tokenHead) {
        this.tokenHead = tokenHead;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public void setRefreshExpiresIn(int refreshExpiresIn) {
        this.refreshExpiresIn = refreshExpiresIn;
    }

    public void setRefreshExp(Long refreshExp) {
        this.refreshExp = refreshExp;
    }

    public String toString() {
        return "Oauth2Token(token=" + this.getToken() + ", refreshToken=" + this.getRefreshToken() + ", tokenHead=" + this.getTokenHead() + ", expiresIn=" + this.getExpiresIn() + ", exp=" + this.getExp() + ", refreshExpiresIn=" + this.getRefreshExpiresIn() + ", refreshExp=" + this.getRefreshExp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Oauth2Token)) {
            return false;
        }
        Oauth2Token other = (Oauth2Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        if (this.getRefreshExpiresIn() != other.getRefreshExpiresIn()) {
            return false;
        }
        Long this$exp = this.getExp();
        Long other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !((Object)this$exp).equals(other$exp)) {
            return false;
        }
        Long this$refreshExp = this.getRefreshExp();
        Long other$refreshExp = other.getRefreshExp();
        if (this$refreshExp == null ? other$refreshExp != null : !((Object)this$refreshExp).equals(other$refreshExp)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$tokenHead = this.getTokenHead();
        String other$tokenHead = other.getTokenHead();
        return !(this$tokenHead == null ? other$tokenHead != null : !this$tokenHead.equals(other$tokenHead));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Oauth2Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiresIn();
        result = result * 59 + this.getRefreshExpiresIn();
        Long $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : ((Object)$exp).hashCode());
        Long $refreshExp = this.getRefreshExp();
        result = result * 59 + ($refreshExp == null ? 43 : ((Object)$refreshExp).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $tokenHead = this.getTokenHead();
        result = result * 59 + ($tokenHead == null ? 43 : $tokenHead.hashCode());
        return result;
    }

    public static class Oauth2TokenBuilder {
        private String token;
        private String refreshToken;
        private String tokenHead;
        private int expiresIn;
        private Long exp;
        private int refreshExpiresIn;
        private Long refreshExp;

        Oauth2TokenBuilder() {
        }

        public Oauth2TokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        public Oauth2TokenBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Oauth2TokenBuilder tokenHead(String tokenHead) {
            this.tokenHead = tokenHead;
            return this;
        }

        public Oauth2TokenBuilder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Oauth2TokenBuilder exp(Long exp) {
            this.exp = exp;
            return this;
        }

        public Oauth2TokenBuilder refreshExpiresIn(int refreshExpiresIn) {
            this.refreshExpiresIn = refreshExpiresIn;
            return this;
        }

        public Oauth2TokenBuilder refreshExp(Long refreshExp) {
            this.refreshExp = refreshExp;
            return this;
        }

        public Oauth2Token build() {
            return new Oauth2Token(this.token, this.refreshToken, this.tokenHead, this.expiresIn, this.exp, this.refreshExpiresIn, this.refreshExp);
        }

        public String toString() {
            return "Oauth2Token.Oauth2TokenBuilder(token=" + this.token + ", refreshToken=" + this.refreshToken + ", tokenHead=" + this.tokenHead + ", expiresIn=" + this.expiresIn + ", exp=" + this.exp + ", refreshExpiresIn=" + this.refreshExpiresIn + ", refreshExp=" + this.refreshExp + ")";
        }
    }
}

