/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.sms.tencent.service.impl;

import com.gitegg.platform.base.enums.ResultCodeEnum;
import com.gitegg.platform.base.result.Result;
import com.gitegg.platform.sms.domain.SmsData;
import com.gitegg.platform.sms.service.ISmsSendService;
import com.gitegg.platform.sms.tencent.props.TencentSmsProperties;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20190711.models.SendStatus;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TencentSmsSendServiceImpl
implements ISmsSendService {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsSendServiceImpl.class);
    private static final String successCode = "Ok";
    private final TencentSmsProperties properties;
    private final SmsClient client;

    public Result<?> sendSms(SmsData smsData, Collection<String> phoneNumbers) {
        SendSmsRequest request = new SendSmsRequest();
        request.setSmsSdkAppid(this.properties.getSmsSdkAppId());
        request.setSign(this.properties.getSignName());
        if (!StringUtils.isEmpty((Object)this.properties.getSenderId())) {
            request.setSenderId(this.properties.getSenderId());
        }
        request.setTemplateID(smsData.getTemplateId());
        String[] phoneNumbersArray = (String[])phoneNumbers.toArray();
        request.setPhoneNumberSet(phoneNumbersArray);
        String[] templateParams = new String[]{};
        if (!CollectionUtils.isEmpty((Map)smsData.getParams())) {
            templateParams = (String[])smsData.getParams().values().toArray();
        }
        request.setTemplateParamSet(templateParams);
        try {
            SendSmsResponse sendSmsResponse = this.client.SendSms(request);
            if (null != sendSmsResponse && null != sendSmsResponse.getSendStatusSet()) {
                SendStatus sendStatus = sendSmsResponse.getSendStatusSet()[0];
                if (successCode.equals(sendStatus.getCode())) {
                    return Result.success((String)sendStatus.getMessage());
                }
                log.error("Send Tencent Sms Fail: [code={}, message={}]", (Object)sendStatus.getCode(), (Object)sendStatus.getMessage());
                return Result.error((ResultCodeEnum)ResultCodeEnum.SMS_SEND_FAILED, (String)sendStatus.getMessage());
            }
        }
        catch (Exception e) {
            log.error("Send Tencent Sms Fail: {}", (Throwable)e);
        }
        return Result.error((ResultCodeEnum)ResultCodeEnum.SMS_SEND_ERROR);
    }

    public TencentSmsSendServiceImpl(TencentSmsProperties properties, SmsClient client) {
        this.properties = properties;
        this.client = client;
    }
}

