/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.model.BEInteger;
import bt.bencoding.model.BEList;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEString;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public class BEEncoder {
    private static final Charset defaultCharset = Charset.forName("UTF-8");
    private static final BEEncoder instance = new BEEncoder();

    public static BEEncoder encoder() {
        return instance;
    }

    public void encode(BEString string, OutputStream out) throws IOException {
        Objects.requireNonNull(string);
        byte[] bytes = string.getValue();
        this.encodeString(bytes, out);
    }

    private void encodeString(byte[] bytes, OutputStream out) throws IOException {
        this.write(out, Integer.toString(bytes.length).getBytes(defaultCharset));
        this.write(out, 58);
        this.write(out, bytes);
    }

    public void encode(BEInteger integer, OutputStream out) throws IOException {
        Objects.requireNonNull(integer);
        BigInteger value = integer.getValue();
        this.write(out, 105);
        this.write(out, Integer.toString(value.intValueExact()).getBytes(defaultCharset));
        this.write(out, 101);
    }

    public void encode(BEList list, OutputStream out) throws IOException {
        Objects.requireNonNull(list);
        Object values = list.getValue();
        this.write(out, 108);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            BEObject value = (BEObject)iterator.next();
            value.writeTo(out);
        }
        this.write(out, 101);
    }

    public void encode(BEMap map, OutputStream out) throws IOException {
        Objects.requireNonNull(map);
        Object values = map.getValue();
        this.write(out, 100);
        ArrayList keys = new ArrayList(values.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            this.encodeString(key.getBytes(defaultCharset), out);
            ((BEObject)values.get(key)).writeTo(out);
        }
        this.write(out, 101);
    }

    private void write(OutputStream out, int i) throws IOException {
        out.write(i);
    }

    private void write(OutputStream out, byte[] bytes) throws IOException {
        out.write(bytes);
    }
}

